/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.TestLoggerRule;
import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.hadoop.AbstractFileSystem;
import alluxio.hadoop.FileSystem;
import alluxio.hadoop.HadoopClientTestUtils;
import java.io.IOException;
import java.net.URI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class AbstractFileSystemApiTest {
    @Rule
    public TestLoggerRule mTestLogger = new TestLoggerRule();
    private InstancedConfiguration mConf = Configuration.copyGlobal();

    @Before
    public void before() {
        this.mConf.set(PropertyKey.METRICS_CONTEXT_SHUTDOWN_TIMEOUT, "0sec");
    }

    @After
    public void after() {
        this.mConf = Configuration.copyGlobal();
        HadoopClientTestUtils.disableMetrics(this.mConf);
    }

    @Test
    public void unknownAuthorityTriggersWarning() throws IOException {
        URI unknown = URI.create("alluxio://test/");
        Exception e = (Exception)Assert.assertThrows(Exception.class, () -> FileSystem.get((URI)unknown, (org.apache.hadoop.conf.Configuration)new org.apache.hadoop.conf.Configuration()));
        Assert.assertTrue((boolean)e.getMessage().contains("Authority \"test\" is unknown. The client can not be configured with the authority from " + unknown));
    }

    @Test
    public void noAuthorityNoWarning() throws IOException {
        URI unknown = URI.create("alluxio:///");
        FileSystem.get((URI)unknown, (org.apache.hadoop.conf.Configuration)new org.apache.hadoop.conf.Configuration());
        Assert.assertFalse((boolean)this.loggedAuthorityWarning());
    }

    @Test
    public void validAuthorityNoWarning() throws IOException {
        URI unknown = URI.create("alluxio://localhost:12345/");
        FileSystem.get((URI)unknown, (org.apache.hadoop.conf.Configuration)new org.apache.hadoop.conf.Configuration());
        Assert.assertFalse((boolean)this.loggedAuthorityWarning());
    }

    @Test
    public void parseZkUriWithPlusDelimiters() throws Exception {
        org.apache.hadoop.fs.FileSystem fs = FileSystem.get((URI)URI.create("alluxio://zk@a:0+b:1+c:2/"), (org.apache.hadoop.conf.Configuration)new org.apache.hadoop.conf.Configuration());
        Assert.assertTrue((boolean)(fs instanceof AbstractFileSystem));
        AbstractFileSystem afs = (AbstractFileSystem)fs;
        Assert.assertTrue((boolean)afs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"a:0,b:1,c:2", (Object)afs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
    }

    private boolean loggedAuthorityWarning() {
        return this.mTestLogger.wasLogged("Authority .* is unknown");
    }
}

