/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.ConfigurationRule;
import alluxio.SystemPropertyRule;
import alluxio.client.block.BlockStoreClient;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.hadoop.AbstractFileSystem;
import alluxio.hadoop.AlluxioFileSystem;
import alluxio.hadoop.FileSystem;
import alluxio.hadoop.HadoopClientTestUtils;
import alluxio.hadoop.HadoopUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BlockStoreClient.class, FileSystemContext.class, FileSystemMasterClient.class, UserGroupInformation.class})
@PowerMockIgnore(value={"javax.security.*"})
public class AbstractFileSystemTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFileSystemTest.class);
    private InstancedConfiguration mConfiguration = alluxio.conf.Configuration.copyGlobal();

    @Before
    public void before() throws Exception {
        this.mockUserGroupInformation("");
        if (HadoopClientTestUtils.isHadoop1x()) {
            LOG.debug("Running Alluxio FS tests against hadoop 1x");
        } else if (HadoopClientTestUtils.isHadoop2x()) {
            LOG.debug("Running Alluxio FS tests against hadoop 2x");
        } else {
            LOG.warn("Running Alluxio FS tests against untargeted Hadoop version: " + HadoopClientTestUtils.getHadoopVersion());
        }
    }

    @After
    public void after() {
        this.mConfiguration = alluxio.conf.Configuration.copyGlobal();
        HadoopClientTestUtils.disableMetrics(this.mConfiguration);
    }

    @Test
    public void hadoopShouldLoadFileSystemWithSingleZkUri() throws Exception {
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://zk@zkHost:2181/tmp/path.txt");
        FileSystem hfs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf));
        Assert.assertTrue((boolean)hfs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"zkHost:2181", (Object)hfs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
    }

    @Test
    public void hadoopShouldLoadFileSystemWithMultipleZkUri() throws Exception {
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://zk@host1:2181,host2:2181,host3:2181/tmp/path.txt");
        org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
        FileSystem hfs = this.getHadoopFilesystem(fs);
        Assert.assertTrue((boolean)hfs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"host1:2181,host2:2181,host3:2181", (Object)hfs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
        uri = URI.create("alluxio://zk@host1:2181;host2:2181;host3:2181/tmp/path.txt");
        fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf));
        Assert.assertTrue((boolean)hfs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"host1:2181,host2:2181,host3:2181", (Object)hfs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
    }

    @Test
    public void fsShouldSetPropertyConfWithLogicalUriConfig() throws Exception {
        URI uri = URI.create("alluxio://ebj@logical/path");
        Configuration conf = this.getConf();
        conf.set(PropertyKey.Template.MASTER_LOGICAL_NAMESERVICES.format(new Object[]{"logical"}).getName(), "master1,master2,master3");
        conf.set(PropertyKey.Template.MASTER_LOGICAL_RPC_ADDRESS.format(new Object[]{"logical", "master1"}).getName(), "host1:19998");
        conf.set(PropertyKey.Template.MASTER_LOGICAL_RPC_ADDRESS.format(new Object[]{"logical", "master2"}).getName(), "host2:19998");
        conf.set(PropertyKey.Template.MASTER_LOGICAL_RPC_ADDRESS.format(new Object[]{"logical", "master3"}).getName(), "host3:19998");
        FileSystem afs = new FileSystem();
        afs.initialize(uri, conf);
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)afs.mFileSystem.getConf().get(PropertyKey.MASTER_RPC_ADDRESSES));
        Assert.assertFalse((boolean)afs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
    }

    @Test
    public void fsShouldTriggersExceptionWithUnknownLogicalUriWith() throws Exception {
        URI uri = URI.create("alluxio://ebj@logical/path");
        FileSystem afs = new FileSystem();
        Assert.assertThrows(Exception.class, () -> this.lambda$fsShouldTriggersExceptionWithUnknownLogicalUriWith$0((AbstractFileSystem)afs, uri));
    }

    @Test
    public void fsShouldSetPropertyConfWithZkLogicalUriConfig() throws Exception {
        URI uri = URI.create("alluxio://zk@logical/path");
        Configuration conf = this.getConf();
        conf.set(PropertyKey.Template.MASTER_LOGICAL_ZOOKEEPER_NAMESERVICES.format(new Object[]{"logical"}).getName(), "node1,node2,node3");
        conf.set(PropertyKey.Template.MASTER_LOGICAL_ZOOKEEPER_ADDRESS.format(new Object[]{"logical", "node1"}).getName(), "host1:2181");
        conf.set(PropertyKey.Template.MASTER_LOGICAL_ZOOKEEPER_ADDRESS.format(new Object[]{"logical", "node2"}).getName(), "host2:2181");
        conf.set(PropertyKey.Template.MASTER_LOGICAL_ZOOKEEPER_ADDRESS.format(new Object[]{"logical", "node3"}).getName(), "host3:2181");
        FileSystem afs = new FileSystem();
        afs.initialize(uri, conf);
        Assert.assertEquals((Object)"host1:2181,host2:2181,host3:2181", (Object)afs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
        Assert.assertTrue((boolean)afs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
    }

    @Test
    public void fsShouldTriggersExceptionWithUnknownZkLogicalUriWith() {
        URI uri = URI.create("alluxio://zk@logical/path");
        FileSystem afs = new FileSystem();
        Assert.assertThrows(Exception.class, () -> this.lambda$fsShouldTriggersExceptionWithUnknownZkLogicalUriWith$1((AbstractFileSystem)afs, uri));
    }

    @Test
    public void fsShouldSetPropertyConfWithMultiMasterUri() throws Exception {
        URI uri = URI.create("alluxio://host1:19998,host2:19998,host3:19998/path");
        FileSystem afs = new FileSystem();
        afs.initialize(uri, this.getConf());
        Assert.assertFalse((boolean)afs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)afs.mFileSystem.getConf().get(PropertyKey.MASTER_RPC_ADDRESSES));
        uri = URI.create("alluxio://host1:19998;host2:19998;host3:19998/path");
        afs = new FileSystem();
        afs.initialize(uri, this.getConf());
        Assert.assertFalse((boolean)afs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)afs.mFileSystem.getConf().get(PropertyKey.MASTER_RPC_ADDRESSES));
    }

    @Test
    public void hadoopShouldLoadFsWithMultiMasterUri() throws Exception {
        URI uri = URI.create("alluxio://host1:19998,host2:19998,host3:19998/path");
        org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf());
        Assert.assertTrue((boolean)(fs instanceof FileSystem));
        uri = URI.create("alluxio://host1:19998;host2:19998;host3:19998/path");
        fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf());
        Assert.assertTrue((boolean)(fs instanceof FileSystem));
    }

    @Test
    public void hadoopShouldLoadFileSystemWhenConfigured() throws Exception {
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://localhost:19998/tmp/path.txt");
        HashMap<PropertyKey, Object> properties = new HashMap<PropertyKey, Object>();
        properties.put(PropertyKey.MASTER_HOSTNAME, uri.getHost());
        properties.put(PropertyKey.MASTER_RPC_PORT, uri.getPort());
        properties.put(PropertyKey.ZOOKEEPER_ENABLED, false);
        properties.put(PropertyKey.ZOOKEEPER_ADDRESS, null);
        try (Closeable c = new ConfigurationRule(properties, this.mConfiguration).toResource();){
            org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
            Assert.assertTrue((boolean)(fs instanceof FileSystem));
        }
    }

    @Test
    public void resetContextUsingZookeeperUris() throws Exception {
        URI uri = URI.create("alluxio://zk@zkHost:2181/");
        FileSystem fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
        Assert.assertTrue((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"zkHost:2181", (Object)fs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
        uri = URI.create("alluxio://zk@host1:2181,host2:2181,host3:2181/tmp/path.txt");
        fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
        Assert.assertTrue((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"host1:2181,host2:2181,host3:2181", (Object)fs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
        uri = URI.create("alluxio://zk@host1:2181;host2:2181;host3:2181/tmp/path.txt");
        fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
        Assert.assertTrue((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"host1:2181,host2:2181,host3:2181", (Object)fs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
    }

    @Test
    public void resetContextFromZkUriToNonZkUri() throws Exception {
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://zk@zkHost:2181/tmp/path.txt");
        FileSystem fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf));
        Assert.assertTrue((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"zkHost:2181", (Object)fs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
        URI otherUri = URI.create("alluxio://alluxioHost:19998/tmp/path.txt");
        fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)otherUri, (Configuration)conf));
        Assert.assertEquals((Object)"alluxioHost", (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_HOSTNAME));
        Assert.assertEquals((Object)19998, (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_RPC_PORT));
        Assert.assertFalse((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertFalse((boolean)fs.mFileSystem.getConf().isSet(PropertyKey.ZOOKEEPER_ADDRESS));
    }

    @Test
    public void resetContextUsingMultiMasterUris() throws Exception {
        URI uri = URI.create("alluxio://host1:19998,host2:19998,host3:19998/tmp/path.txt");
        FileSystem fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
        Assert.assertFalse((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_RPC_ADDRESSES));
    }

    @Test
    public void resetContextFromZookeeperToMultiMaster() throws Exception {
        URI uri = URI.create("alluxio://zk@zkHost:2181/tmp/path.txt");
        FileSystem fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
        Assert.assertTrue((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"zkHost:2181", (Object)fs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
        uri = URI.create("alluxio://host1:19998,host2:19998,host3:19998/tmp/path.txt");
        fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
        Assert.assertFalse((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((long)3L, (long)ConfigurationUtils.getMasterRpcAddresses((AlluxioConfiguration)fs.mFileSystem.getConf()).size());
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_RPC_ADDRESSES));
    }

    @Test
    public void resetContextFromMultiMasterToSingleMaster() throws Exception {
        URI uri = URI.create("alluxio://host1:19998,host2:19998,host3:19998/tmp/path.txt");
        FileSystem fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
        Assert.assertFalse((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((long)3L, (long)ConfigurationUtils.getMasterRpcAddresses((AlluxioConfiguration)fs.mFileSystem.getConf()).size());
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_RPC_ADDRESSES));
        uri = URI.create("alluxio://host:19998/tmp/path.txt");
        fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
        Assert.assertFalse((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)PropertyKey.MASTER_JOURNAL_TYPE.getDefaultValue(), (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_JOURNAL_TYPE));
        Assert.assertEquals((long)1L, (long)ConfigurationUtils.getMasterRpcAddresses((AlluxioConfiguration)fs.mFileSystem.getConf()).size());
    }

    @Test
    public void concurrentInitialize() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        Configuration conf = this.getConf();
        for (int i = 0; i < 100; ++i) {
            Thread t = new Thread(() -> {
                URI uri = URI.create("alluxio://randomhost:410/");
                try {
                    org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
                }
                catch (IOException e) {
                    Assert.fail();
                }
            });
            threads.add(t);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
    }

    @Test
    public void reinitializeWithDifferentURI() throws Exception {
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://host1:1");
        FileSystem fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf));
        Assert.assertEquals((Object)"host1", (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_HOSTNAME));
        Assert.assertEquals((Object)1, (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_RPC_PORT));
        uri = URI.create("alluxio://host2:2");
        fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf));
        Assert.assertEquals((Object)"host2", (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_HOSTNAME));
        Assert.assertEquals((Object)2, (Object)fs.mFileSystem.getConf().get(PropertyKey.MASTER_RPC_PORT));
    }

    @Test
    public void listStatus() throws Exception {
        FileInfo fileInfo1 = new FileInfo().setLastModificationTimeMs(111L).setLastAccessTimeMs(123L).setFolder(false).setOwner("user1").setGroup("group1").setMode(493);
        FileInfo fileInfo2 = new FileInfo().setLastModificationTimeMs(222L).setLastAccessTimeMs(234L).setFolder(true).setOwner("user2").setGroup("group2").setMode(420);
        Path path = new Path("/dir");
        alluxio.client.file.FileSystem alluxioFs = (alluxio.client.file.FileSystem)Mockito.mock(alluxio.client.file.FileSystem.class);
        Mockito.when((Object)alluxioFs.listStatus(new AlluxioURI(HadoopUtils.getPathWithoutScheme((Path)path)))).thenReturn((Object)Lists.newArrayList((Object[])new URIStatus[]{new URIStatus(fileInfo1), new URIStatus(fileInfo2)}));
        FileSystem alluxioHadoopFs = new FileSystem(alluxioFs);
        FileStatus[] fileStatuses = alluxioHadoopFs.listStatus(path);
        this.assertFileInfoEqualsFileStatus(fileInfo1, fileStatuses[0]);
        this.assertFileInfoEqualsFileStatus(fileInfo2, fileStatuses[1]);
        alluxioHadoopFs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void throwFileNotFoundExceptionWhenListStatusNonExistingTest() throws Exception {
        FileSystem alluxioHadoopFs = null;
        try {
            Path path = new Path("/ALLUXIO-2036");
            alluxio.client.file.FileSystem alluxioFs = (alluxio.client.file.FileSystem)Mockito.mock(alluxio.client.file.FileSystem.class);
            Mockito.when((Object)alluxioFs.listStatus(new AlluxioURI(HadoopUtils.getPathWithoutScheme((Path)path)))).thenThrow(new Throwable[]{new FileNotFoundException("ALLUXIO-2036 not Found")});
            alluxioHadoopFs = new FileSystem(alluxioFs);
            FileStatus[] fileStatuses = alluxioHadoopFs.listStatus(path);
            Assert.assertTrue((boolean)false);
        }
        catch (FileNotFoundException fnf) {
            Assert.assertEquals((Object)"ALLUXIO-2036 not Found", (Object)fnf.getMessage());
        }
        finally {
            if (null != alluxioHadoopFs) {
                try {
                    alluxioHadoopFs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Test
    public void getStatus() throws Exception {
        FileInfo fileInfo = new FileInfo().setLastModificationTimeMs(111L).setLastAccessTimeMs(123L).setFolder(false).setOwner("user1").setGroup("group1").setMode(493);
        Path path = new Path("/dir");
        alluxio.client.file.FileSystem alluxioFs = (alluxio.client.file.FileSystem)Mockito.mock(alluxio.client.file.FileSystem.class);
        Mockito.when((Object)alluxioFs.getStatus(new AlluxioURI(HadoopUtils.getPathWithoutScheme((Path)path)))).thenReturn((Object)new URIStatus(fileInfo));
        FileSystem alluxioHadoopFs = new FileSystem(alluxioFs);
        FileStatus fileStatus = alluxioHadoopFs.getFileStatus(path);
        this.assertFileInfoEqualsFileStatus(fileInfo, fileStatus);
    }

    @Test
    public void initializeWithCustomizedUgi() throws Exception {
        this.mockUserGroupInformation("testuser");
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://host:1");
        org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
    }

    @Test
    public void initializeWithFullPrincipalUgi() throws Exception {
        this.mockUserGroupInformation("testuser@ALLUXIO.COM");
        Configuration conf = this.getConf();
        URI uri = URI.create("alluxio://host:1");
        org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
    }

    @Test
    public void initializeWithZookeeperSystemProperties() throws Exception {
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), "true");
        sysProps.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), "zkHost:2181");
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            alluxio.conf.Configuration.reloadProperties();
            URI uri = URI.create("alluxio:///");
            FileSystem fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
            Assert.assertTrue((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
            Assert.assertEquals((Object)"zkHost:2181", (Object)fs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
        }
    }

    @Test
    public void initializeWithZookeeperUriAndSystemProperty() throws Exception {
        try (Closeable p = new SystemPropertyRule(PropertyKey.ZOOKEEPER_ENABLED.getName(), "false").toResource();){
            alluxio.conf.Configuration.reloadProperties();
            URI uri = URI.create("alluxio://zk@zkHost:2181");
            FileSystem fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
            Assert.assertTrue((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
            Assert.assertEquals((Object)"zkHost:2181", (Object)fs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
            fs.close();
        }
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), "true");
        sysProps.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), "zkHost1:2181");
        try (Closeable p = new SystemPropertyRule(sysProps).toResource();){
            alluxio.conf.Configuration.reloadProperties();
            URI uri = URI.create("alluxio://zk@zkHost2:2181");
            FileSystem fs = this.getHadoopFilesystem(org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)this.getConf()));
            Assert.assertTrue((boolean)fs.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
            Assert.assertEquals((Object)"zkHost2:2181", (Object)fs.mFileSystem.getConf().get(PropertyKey.ZOOKEEPER_ADDRESS));
            fs.close();
        }
        alluxio.conf.Configuration.reloadProperties();
    }

    @Test
    public void getBlockLocationsOnlyInAlluxio() throws Exception {
        WorkerNetAddress worker1 = new WorkerNetAddress().setHost("worker1").setDataPort(1234);
        WorkerNetAddress worker2 = new WorkerNetAddress().setHost("worker2").setDataPort(1234);
        List<WorkerNetAddress> blockWorkers = Arrays.asList(worker1);
        List<String> ufsLocations = Arrays.asList(new String[0]);
        List<WorkerNetAddress> allWorkers = Arrays.asList(worker1, worker2);
        List<WorkerNetAddress> expectedWorkers = Arrays.asList(worker1);
        this.verifyBlockLocations(blockWorkers, ufsLocations, allWorkers, expectedWorkers);
    }

    @Test
    public void getBlockLocationsInUfs() throws Exception {
        WorkerNetAddress worker1 = new WorkerNetAddress().setHost("worker1").setDataPort(1234);
        WorkerNetAddress worker2 = new WorkerNetAddress().setHost("worker2").setDataPort(1234);
        List<WorkerNetAddress> blockWorkers = Arrays.asList(new WorkerNetAddress[0]);
        List<String> ufsLocations = Arrays.asList(worker2.getHost());
        List<WorkerNetAddress> allWorkers = Arrays.asList(worker1, worker2);
        List<WorkerNetAddress> expectedWorkers = Arrays.asList(worker2);
        this.verifyBlockLocations(blockWorkers, ufsLocations, allWorkers, expectedWorkers);
    }

    @Test
    public void getBlockLocationsInUfsAndAlluxio() throws Exception {
        WorkerNetAddress worker1 = new WorkerNetAddress().setHost("worker1").setDataPort(1234);
        WorkerNetAddress worker2 = new WorkerNetAddress().setHost("worker2").setDataPort(1234);
        List<WorkerNetAddress> blockWorkers = Arrays.asList(worker1);
        List<String> ufsLocations = Arrays.asList(worker2.getHost());
        List<WorkerNetAddress> allWorkers = Arrays.asList(worker1, worker2);
        List<WorkerNetAddress> expectedWorkers = Arrays.asList(worker1);
        this.verifyBlockLocations(blockWorkers, ufsLocations, allWorkers, expectedWorkers);
    }

    @Test
    public void getBlockLocationsOnlyMatchingWorkers() throws Exception {
        WorkerNetAddress worker1 = new WorkerNetAddress().setHost("worker1").setDataPort(1234);
        WorkerNetAddress worker2 = new WorkerNetAddress().setHost("worker2").setDataPort(1234);
        List<WorkerNetAddress> blockWorkers = Arrays.asList(new WorkerNetAddress[0]);
        List<String> ufsLocations = Arrays.asList("worker0", worker2.getHost(), "worker3");
        List<WorkerNetAddress> allWorkers = Arrays.asList(worker1, worker2);
        List<WorkerNetAddress> expectedWorkers = Arrays.asList(worker2);
        this.verifyBlockLocations(blockWorkers, ufsLocations, allWorkers, expectedWorkers);
    }

    @Test
    public void getBlockLocationsNoMatchingWorkersDefault() throws Exception {
        WorkerNetAddress worker1 = new WorkerNetAddress().setHost("worker1").setDataPort(1234);
        WorkerNetAddress worker2 = new WorkerNetAddress().setHost("worker2").setDataPort(1234);
        List<WorkerNetAddress> blockWorkers = Arrays.asList(new WorkerNetAddress[0]);
        List<String> ufsLocations = Arrays.asList("worker0", "worker3");
        List<WorkerNetAddress> allWorkers = Arrays.asList(worker1, worker2);
        this.verifyBlockLocations(blockWorkers, ufsLocations, allWorkers, allWorkers);
    }

    @Test
    public void getBlockLocationsNoMatchingWorkersWithFallback() throws Exception {
        WorkerNetAddress worker1 = new WorkerNetAddress().setHost("worker1").setDataPort(1234);
        WorkerNetAddress worker2 = new WorkerNetAddress().setHost("worker2").setDataPort(1234);
        List<WorkerNetAddress> blockWorkers = Arrays.asList(new WorkerNetAddress[0]);
        List<String> ufsLocations = Arrays.asList("worker0", "worker3");
        List<WorkerNetAddress> allWorkers = Arrays.asList(worker1, worker2);
        List<WorkerNetAddress> expectedWorkers = Arrays.asList(worker1, worker2);
        try (Closeable conf = new ConfigurationRule(PropertyKey.USER_UFS_BLOCK_LOCATION_ALL_FALLBACK_ENABLED, (Object)true, this.mConfiguration).toResource();){
            this.verifyBlockLocations(blockWorkers, ufsLocations, allWorkers, expectedWorkers);
        }
    }

    @Test
    public void getBlockLocationsNoUfsLocationsDefault() throws Exception {
        WorkerNetAddress worker1 = new WorkerNetAddress().setHost("worker1").setDataPort(1234);
        WorkerNetAddress worker2 = new WorkerNetAddress().setHost("worker2").setDataPort(1234);
        List<WorkerNetAddress> blockWorkers = Arrays.asList(new WorkerNetAddress[0]);
        List<String> ufsLocations = Arrays.asList(new String[0]);
        List<WorkerNetAddress> allWorkers = Arrays.asList(worker1, worker2);
        this.verifyBlockLocations(blockWorkers, ufsLocations, allWorkers, allWorkers);
    }

    @Test
    public void getBlockLocationsNoUfsLocationsWithFallback() throws Exception {
        WorkerNetAddress worker1 = new WorkerNetAddress().setHost("worker1").setDataPort(1234);
        WorkerNetAddress worker2 = new WorkerNetAddress().setHost("worker2").setDataPort(1234);
        List<WorkerNetAddress> blockWorkers = Arrays.asList(new WorkerNetAddress[0]);
        List<String> ufsLocations = Arrays.asList(new String[0]);
        List<WorkerNetAddress> allWorkers = Arrays.asList(worker1, worker2);
        List<WorkerNetAddress> expectedWorkers = Arrays.asList(worker1, worker2);
        try (Closeable conf = new ConfigurationRule(PropertyKey.USER_UFS_BLOCK_LOCATION_ALL_FALLBACK_ENABLED, (Object)true, this.mConfiguration).toResource();){
            this.verifyBlockLocations(blockWorkers, ufsLocations, allWorkers, expectedWorkers);
        }
    }

    @Test
    public void appendExistingNotSupported() throws Exception {
        Path path = new Path("/file");
        alluxio.client.file.FileSystem alluxioFs = (alluxio.client.file.FileSystem)Mockito.mock(alluxio.client.file.FileSystem.class);
        Mockito.when((Object)alluxioFs.exists(new AlluxioURI(HadoopUtils.getPathWithoutScheme((Path)path)))).thenReturn((Object)true);
        try (FileSystem alluxioHadoopFs = new FileSystem(alluxioFs);){
            alluxioHadoopFs.append(path, 100);
            Assert.fail((String)"append() of existing file is expected to fail");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)("append() to existing Alluxio path is currently not supported: " + path), (Object)e.getMessage());
        }
    }

    @Test
    public void createWithoutOverwrite() throws Exception {
        Path path = new Path("/file");
        alluxio.client.file.FileSystem alluxioFs = (alluxio.client.file.FileSystem)Mockito.mock(alluxio.client.file.FileSystem.class);
        Mockito.when((Object)alluxioFs.exists(new AlluxioURI(HadoopUtils.getPathWithoutScheme((Path)path)))).thenReturn((Object)true);
        Mockito.when((Object)alluxioFs.createFile((AlluxioURI)ArgumentMatchers.eq((Object)new AlluxioURI(HadoopUtils.getPathWithoutScheme((Path)path))), (CreateFilePOptions)ArgumentMatchers.any())).thenThrow(new Throwable[]{new FileAlreadyExistsException(path.toString())});
        try (FileSystem alluxioHadoopFs = new FileSystem(alluxioFs);){
            alluxioHadoopFs.create(path, false, 100, (short)1, 1000L);
            Assert.fail((String)"create() of existing file is expected to fail");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)("Not allowed to create() (overwrite=false) for existing Alluxio path: " + path), (Object)e.getMessage());
        }
    }

    @Test
    public void defaultPortTest() throws Exception {
        int defaultRpcPort = (Integer)PropertyKey.MASTER_RPC_PORT.getDefaultValue();
        Configuration conf = new Configuration();
        conf.set("fs.AbstractFileSystem.alluxio.impl", "alluxio.hadoop.AlluxioFileSystem");
        conf.set("fs.alluxio.impl", "alluxio.hadoop.FileSystem");
        URI uri = new URI("alluxio:///test");
        org.apache.hadoop.fs.AbstractFileSystem system = org.apache.hadoop.fs.AbstractFileSystem.createFileSystem((URI)uri, (Configuration)conf);
        Assert.assertTrue((boolean)(system instanceof AlluxioFileSystem));
        Assert.assertEquals((long)defaultRpcPort, (long)system.getUriDefaultPort());
        org.apache.hadoop.fs.FileSystem system2 = org.apache.hadoop.fs.FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertTrue((boolean)(system2 instanceof FileSystem));
        Assert.assertEquals((long)defaultRpcPort, (long)((FileSystem)system2).getDefaultPort());
    }

    void verifyBlockLocations(List<WorkerNetAddress> blockWorkers, List<String> ufsLocations, List<WorkerNetAddress> allWorkers, List<WorkerNetAddress> expectedWorkers) throws Exception {
        FileBlockInfo blockInfo = new FileBlockInfo().setBlockInfo(new BlockInfo().setLocations(blockWorkers.stream().map(addr -> new BlockLocation().setWorkerAddress(addr)).collect(Collectors.toList()))).setUfsLocations(ufsLocations);
        FileInfo fileInfo = new FileInfo().setLastModificationTimeMs(111L).setLastAccessTimeMs(123L).setFolder(false).setOwner("user1").setGroup("group1").setMode(493).setFileBlockInfos(Arrays.asList(blockInfo));
        Path path = new Path("/dir/file");
        AlluxioURI uri = new AlluxioURI(HadoopUtils.getPathWithoutScheme((Path)path));
        BlockStoreClient blockStore = (BlockStoreClient)Mockito.mock(BlockStoreClient.class);
        PowerMockito.mockStatic(BlockStoreClient.class, (Class[])new Class[0]);
        PowerMockito.when((Object)BlockStoreClient.create((FileSystemContext)((FileSystemContext)ArgumentMatchers.any(FileSystemContext.class)))).thenReturn((Object)blockStore);
        FileSystemContext fsContext = (FileSystemContext)Mockito.mock(FileSystemContext.class);
        Mockito.when((Object)fsContext.getClientContext()).thenReturn((Object)ClientContext.create((AlluxioConfiguration)this.mConfiguration));
        Mockito.when((Object)fsContext.getClusterConf()).thenReturn((Object)this.mConfiguration);
        Mockito.when((Object)fsContext.getPathConf((AlluxioURI)ArgumentMatchers.any(AlluxioURI.class))).thenReturn((Object)this.mConfiguration);
        alluxio.client.file.FileSystem fs = FileSystem.Factory.create((FileSystemContext)fsContext);
        alluxio.client.file.FileSystem spyFs = (alluxio.client.file.FileSystem)Mockito.spy((Object)fs);
        ((alluxio.client.file.FileSystem)Mockito.doReturn((Object)new URIStatus(fileInfo)).when((Object)spyFs)).getStatus(uri);
        List eligibleWorkerInfos = allWorkers.stream().map(worker -> new BlockWorkerInfo(worker, 0L, 0L)).collect(Collectors.toList());
        Mockito.when((Object)fsContext.getCachedWorkers()).thenReturn(eligibleWorkerInfos);
        List expectedWorkerNames = expectedWorkers.stream().map(addr -> HostAndPort.fromParts((String)addr.getHost(), (int)addr.getDataPort())).collect(Collectors.toList());
        FileSystem alluxioHadoopFs = new FileSystem(spyFs);
        FileStatus file = new FileStatus(0L, false, 0, 0L, 0L, 0L, null, null, null, path);
        long start = 0L;
        long len = 100L;
        org.apache.hadoop.fs.BlockLocation[] locations = alluxioHadoopFs.getFileBlockLocations(file, start, len);
        Assert.assertEquals((long)1L, (long)locations.length);
        Collections.sort(expectedWorkerNames, (x, y) -> x.toString().compareTo(y.toString()));
        Object[] actualNames = locations[0].getNames();
        Object[] actualHosts = locations[0].getHosts();
        Arrays.sort(actualNames);
        Arrays.sort(actualHosts);
        Assert.assertArrayEquals((Object[])expectedWorkerNames.stream().map(HostAndPort::toString).toArray(), (Object[])actualNames);
        Assert.assertArrayEquals((Object[])expectedWorkerNames.stream().map(HostAndPort::getHost).toArray(), (Object[])actualHosts);
        alluxioHadoopFs.close();
    }

    private Configuration getConf() throws Exception {
        Configuration conf = new Configuration();
        if (HadoopClientTestUtils.isHadoop1x()) {
            conf.set("fs.alluxio.impl", FileSystem.class.getName());
        }
        return conf;
    }

    private FileSystem getHadoopFilesystem(org.apache.hadoop.fs.FileSystem fs) {
        Assert.assertTrue((boolean)(fs instanceof FileSystem));
        return (FileSystem)fs;
    }

    private void mockUserGroupInformation(String username) throws IOException {
        PowerMockito.mockStatic(UserGroupInformation.class, (Class[])new Class[0]);
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)UserGroupInformation.getCurrentUser()).thenReturn((Object)ugi);
        Mockito.when((Object)ugi.getUserName()).thenReturn((Object)username);
        Mockito.when((Object)ugi.getShortUserName()).thenReturn((Object)username.split("@")[0]);
    }

    private void assertFileInfoEqualsFileStatus(FileInfo info, FileStatus status) {
        Assert.assertEquals((Object)info.getOwner(), (Object)status.getOwner());
        Assert.assertEquals((Object)info.getGroup(), (Object)status.getGroup());
        Assert.assertEquals((long)info.getMode(), (long)status.getPermission().toShort());
        Assert.assertEquals((long)info.getLastModificationTimeMs(), (long)status.getModificationTime());
        Assert.assertEquals((long)info.getLastAccessTimeMs(), (long)status.getAccessTime());
        Assert.assertEquals((Object)info.isFolder(), (Object)status.isDir());
    }

    private /* synthetic */ void lambda$fsShouldTriggersExceptionWithUnknownZkLogicalUriWith$1(AbstractFileSystem afs, URI uri) throws Throwable {
        afs.initialize(uri, this.getConf());
    }

    private /* synthetic */ void lambda$fsShouldTriggersExceptionWithUnknownLogicalUriWith$0(AbstractFileSystem afs, URI uri) throws Throwable {
        afs.initialize(uri, this.getConf());
    }
}

