/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import java.net.URL;
import org.powermock.core.classloader.MockClassLoader;

public final class HadoopClientTestUtils {
    public static void disableMetrics(InstancedConfiguration conf) {
        conf.set(PropertyKey.USER_METRICS_COLLECTION_ENABLED, (Object)false);
    }

    public static boolean isHadoop1x() {
        return HadoopClientTestUtils.getHadoopVersion().startsWith("1");
    }

    public static boolean isHadoop2x() {
        return HadoopClientTestUtils.getHadoopVersion().startsWith("2");
    }

    public static String getHadoopVersion() {
        return "3.3.1";
    }

    private static URL getSourcePath(Class<?> clazz) {
        try {
            clazz = HadoopClientTestUtils.getClassLoader(clazz).loadClass(clazz.getName());
            return clazz.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("Unable to find class " + clazz.getName()));
        }
    }

    private static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof MockClassLoader) {
            cl = cl.getParent();
        }
        return cl;
    }
}

