/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.conf.Configuration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.hadoop.HadoopConfigurationUtils;
import org.junit.Assert;
import org.junit.Test;

public final class HadoopConfigurationUtilsTest {
    private static final String TEST_S3_ACCCES_KEY = "TEST ACCESS KEY";
    private static final String TEST_S3_SECRET_KEY = "TEST SECRET KEY";
    private static final String TEST_ALLUXIO_PROPERTY = "alluxio.unsupported.parameter";
    private static final String TEST_ALLUXIO_VALUE = "alluxio.unsupported.value";
    private InstancedConfiguration mConf = Configuration.copyGlobal();

    @Test
    public void mergeEmptyHadoopConfiguration() {
        org.apache.hadoop.conf.Configuration hadoopConfig = new org.apache.hadoop.conf.Configuration();
        this.mConf.merge(HadoopConfigurationUtils.getConfigurationFromHadoop((org.apache.hadoop.conf.Configuration)hadoopConfig), Source.RUNTIME);
        Assert.assertFalse((boolean)this.mConf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
    }

    @Test
    public void mergeHadoopConfiguration() {
        org.apache.hadoop.conf.Configuration hadoopConfig = new org.apache.hadoop.conf.Configuration();
        hadoopConfig.set(PropertyKey.S3A_ACCESS_KEY.toString(), TEST_S3_ACCCES_KEY);
        hadoopConfig.set(PropertyKey.S3A_SECRET_KEY.toString(), TEST_S3_SECRET_KEY);
        hadoopConfig.set(TEST_ALLUXIO_PROPERTY, TEST_ALLUXIO_VALUE);
        hadoopConfig.setBoolean(PropertyKey.ZOOKEEPER_ENABLED.getName(), true);
        hadoopConfig.set(PropertyKey.ZOOKEEPER_ADDRESS.getName(), "host1:port1,host2:port2;host3:port3");
        hadoopConfig.set("hadoop.config.parameter", "hadoop config value");
        this.mConf.merge(HadoopConfigurationUtils.getConfigurationFromHadoop((org.apache.hadoop.conf.Configuration)hadoopConfig), Source.RUNTIME);
        Assert.assertEquals((Object)TEST_S3_ACCCES_KEY, (Object)this.mConf.get(PropertyKey.S3A_ACCESS_KEY));
        Assert.assertEquals((Object)TEST_S3_SECRET_KEY, (Object)this.mConf.get(PropertyKey.S3A_SECRET_KEY));
        Assert.assertEquals((Object)Source.RUNTIME, (Object)this.mConf.getSource(PropertyKey.S3A_ACCESS_KEY));
        Assert.assertEquals((Object)Source.RUNTIME, (Object)this.mConf.getSource(PropertyKey.S3A_SECRET_KEY));
        Assert.assertTrue((boolean)this.mConf.getBoolean(PropertyKey.ZOOKEEPER_ENABLED));
        Assert.assertEquals((Object)"host1:port1,host2:port2;host3:port3", (Object)this.mConf.get(PropertyKey.ZOOKEEPER_ADDRESS));
    }
}

