/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.hadoop.HadoopUtils;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public final class HadoopUtilsTest {
    @Test
    public void testGetPathWithoutSchema() {
        Path path = new Path("/foo/bar/baz");
        String output = HadoopUtils.getPathWithoutScheme((Path)path);
        Assert.assertEquals((Object)"/foo/bar/baz", (Object)output);
    }

    @Test
    public void testGetPathWithoutSchemaThatContainsSchema() {
        Path path = new Path("file:///foo/bar/baz");
        String output = HadoopUtils.getPathWithoutScheme((Path)path);
        Assert.assertEquals((Object)"/foo/bar/baz", (Object)output);
    }

    @Test
    public void testGetPathWithoutSchemaFromHDFS() {
        Path path = new Path("hdfs://localhost:1234/foo/bar/baz?please=dont&show=up");
        String output = HadoopUtils.getPathWithoutScheme((Path)path);
        Assert.assertFalse((boolean)"/foo/bar/baz".equals(output));
    }

    @Test
    public void testGetPathWithoutSchemaFromHDFSURI() {
        Path path = new Path(URI.create("hdfs://localhost:1234/foo/bar/baz?please=dont&show=up"));
        String output = HadoopUtils.getPathWithoutScheme((Path)path);
        Assert.assertEquals((Object)"/foo/bar/baz", (Object)output);
    }

    @Test
    public void testGetPathWithoutSchemeFromZookeeperURI() {
        Path path = new Path(URI.create("alluxio://zk@host1:port1,host2:port2,host3:port3/foo/bar/baz"));
        String output = HadoopUtils.getPathWithoutScheme((Path)path);
        Assert.assertEquals((Object)"/foo/bar/baz", (Object)output);
    }
}

