/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.PositionReader;
import alluxio.file.ByteArrayTargetBuffer;
import alluxio.file.ReadTargetBuffer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;

public class AlluxioHdfsPositionReader
implements PositionReader {
    private final FSDataInputStream mInput;
    private final long mFileSize;
    private volatile boolean mClosed;

    public AlluxioHdfsPositionReader(FSDataInputStream input, long fileSize) {
        this.mInput = (FSDataInputStream)Preconditions.checkNotNull((Object)input, (Object)"null");
        this.mFileSize = fileSize;
    }

    public int readInternal(long position, ReadTargetBuffer buffer, int length) throws IOException {
        Preconditions.checkArgument((!this.mClosed ? 1 : 0) != 0, (Object)"position reader is closed");
        if (position >= this.mFileSize) {
            return -1;
        }
        boolean targetIsByteArray = buffer instanceof ByteArrayTargetBuffer;
        int lengthToRead = (int)Math.min((long)length, this.mFileSize - position);
        byte[] byteArray = targetIsByteArray ? buffer.byteArray() : new byte[lengthToRead];
        int arrayPosition = targetIsByteArray ? buffer.offset() : 0;
        this.mInput.readFully(position, byteArray, arrayPosition, lengthToRead);
        if (targetIsByteArray) {
            buffer.offset(arrayPosition + lengthToRead);
        } else {
            buffer.writeBytes(byteArray, 0, lengthToRead);
        }
        return lengthToRead;
    }

    public synchronized void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mInput.close();
    }
}

