/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.client.file.URIStatus;
import alluxio.conf.PropertyKey;
import alluxio.hadoop.AbstractFileSystem;
import alluxio.hadoop.HadoopUtils;
import alluxio.uri.EmbeddedLogicalAuthority;
import alluxio.uri.MultiMasterAuthority;
import alluxio.uri.SingleMasterAuthority;
import alluxio.uri.ZookeeperAuthority;
import alluxio.uri.ZookeeperLogicalAuthority;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

@NotThreadSafe
public class FileSystem
extends AbstractFileSystem {
    public FileSystem() {
    }

    public FileSystem(alluxio.client.file.FileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    public String getScheme() {
        return "alluxio";
    }

    @Override
    protected boolean isZookeeperMode() {
        return this.mFileSystem.getConf().getBoolean(PropertyKey.ZOOKEEPER_ENABLED);
    }

    @Override
    protected Map<String, Object> getConfigurationFromUri(URI uri, Configuration conf) {
        AlluxioURI alluxioUri = new AlluxioURI(uri.toString());
        HashMap<String, Object> alluxioConfProperties = new HashMap<String, Object>();
        if (alluxioUri.getAuthority() instanceof ZookeeperAuthority) {
            ZookeeperAuthority authority = (ZookeeperAuthority)alluxioUri.getAuthority();
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), true);
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), authority.getZookeeperAddress());
        } else if (alluxioUri.getAuthority() instanceof SingleMasterAuthority) {
            SingleMasterAuthority authority = (SingleMasterAuthority)alluxioUri.getAuthority();
            alluxioConfProperties.put(PropertyKey.MASTER_HOSTNAME.getName(), authority.getHost());
            alluxioConfProperties.put(PropertyKey.MASTER_RPC_PORT.getName(), authority.getPort());
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), false);
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), null);
            alluxioConfProperties.put(PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES.getName(), null);
            alluxioConfProperties.put(PropertyKey.MASTER_RPC_ADDRESSES.getName(), null);
        } else if (alluxioUri.getAuthority() instanceof MultiMasterAuthority) {
            MultiMasterAuthority authority = (MultiMasterAuthority)alluxioUri.getAuthority();
            alluxioConfProperties.put(PropertyKey.MASTER_RPC_ADDRESSES.getName(), authority.getMasterAddresses());
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), false);
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), null);
        } else if (alluxioUri.getAuthority() instanceof EmbeddedLogicalAuthority) {
            EmbeddedLogicalAuthority authority = (EmbeddedLogicalAuthority)alluxioUri.getAuthority();
            String masterNamesConfKey = PropertyKey.Template.MASTER_LOGICAL_NAMESERVICES.format(new Object[]{authority.getLogicalName()}).getName();
            String[] masterNames = conf.getTrimmedStrings(masterNamesConfKey);
            Preconditions.checkArgument((masterNames.length != 0 ? 1 : 0) != 0, (String)"Invalid uri. You must set %s to use the logical name ", (Object)masterNamesConfKey);
            StringJoiner masterRpcAddress = new StringJoiner(",");
            for (String masterName : masterNames) {
                String name = PropertyKey.Template.MASTER_LOGICAL_RPC_ADDRESS.format(new Object[]{authority.getLogicalName(), masterName}).getName();
                String address = conf.get(name);
                Preconditions.checkArgument((address != null ? 1 : 0) != 0, (String)"You need to set %s", (Object)name);
                masterRpcAddress.add(address);
            }
            alluxioConfProperties.put(PropertyKey.MASTER_RPC_ADDRESSES.getName(), masterRpcAddress.toString());
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), false);
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), null);
        } else if (alluxioUri.getAuthority() instanceof ZookeeperLogicalAuthority) {
            ZookeeperLogicalAuthority authority = (ZookeeperLogicalAuthority)alluxioUri.getAuthority();
            String zkNodesConfKey = PropertyKey.Template.MASTER_LOGICAL_ZOOKEEPER_NAMESERVICES.format(new Object[]{authority.getLogicalName()}).getName();
            String[] zkNodeNames = conf.getTrimmedStrings(zkNodesConfKey);
            Preconditions.checkArgument((zkNodeNames.length != 0 ? 1 : 0) != 0, (String)"Invalid uri. You must set %s to use the logical name", (Object)zkNodesConfKey);
            StringJoiner zkAddress = new StringJoiner(",");
            for (String zkName : zkNodeNames) {
                String name = PropertyKey.Template.MASTER_LOGICAL_ZOOKEEPER_ADDRESS.format(new Object[]{authority.getLogicalName(), zkName}).getName();
                String address = conf.get(name);
                Preconditions.checkArgument((address != null ? 1 : 0) != 0, (String)"You need to set %s", (Object)name);
                zkAddress.add(address);
            }
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ENABLED.getName(), true);
            alluxioConfProperties.put(PropertyKey.ZOOKEEPER_ADDRESS.getName(), zkAddress.toString());
        }
        return alluxioConfProperties;
    }

    @Override
    protected String getFsScheme(URI fsUri) {
        return this.getScheme();
    }

    @Override
    protected AlluxioURI getAlluxioPath(Path path) {
        return new AlluxioURI(HadoopUtils.getPathWithoutScheme(path));
    }

    @Override
    protected Path getFsPath(String fsUriHeader, URIStatus fileStatus) {
        return new Path(fsUriHeader + fileStatus.getPath());
    }
}

