/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HadoopConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopConfigurationUtils.class);

    private HadoopConfigurationUtils() {
    }

    public static Map<String, Object> getConfigurationFromHadoop(Configuration hadoopConf) {
        HashMap<String, Object> alluxioConfProperties = new HashMap<String, Object>();
        for (Map.Entry entry : hadoopConf) {
            String propertyName = (String)entry.getKey();
            if (!PropertyKey.isValid((String)propertyName)) continue;
            alluxioConfProperties.put(propertyName, entry.getValue());
        }
        return alluxioConfProperties;
    }

    public static Configuration mergeAlluxioConfiguration(Configuration source, AlluxioConfiguration alluxioConf) {
        Configuration mergedConf = new Configuration();
        source.forEach(e -> mergedConf.set((String)e.getKey(), (String)e.getValue()));
        alluxioConf.copyProperties().forEach((pk, val) -> {
            if (val != null) {
                mergedConf.set(pk.getName(), String.valueOf(val));
            }
        });
        return mergedConf;
    }
}

