/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.suite;

import alluxio.stress.cli.suite.Suite;
import alluxio.stress.common.AbstractMaxThroughputSummary;
import alluxio.stress.common.GeneralBenchSummary;
import alluxio.stress.common.GeneralParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaxThroughput<T extends AbstractMaxThroughputSummary<P, S>, S extends GeneralBenchSummary, P extends GeneralParameters>
extends Suite<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractMaxThroughput.class);

    protected int getBestThroughput(int initialThroughput, T summary, List<String> baseArgs, int numWorkers) throws Exception {
        int current;
        int lower = 0;
        int upper = Integer.MAX_VALUE;
        int next = initialThroughput;
        int best = 0;
        do {
            int perWorkerThroughput = next / numWorkers;
            int requestedThroughput = perWorkerThroughput * numWorkers;
            if (perWorkerThroughput == 0) break;
            ArrayList<String> newArgs = new ArrayList<String>(baseArgs);
            this.updateArgValue(newArgs, "--target-throughput", Integer.toString(perWorkerThroughput));
            S mbr = this.runSingleTest(newArgs);
            current = next;
            float actualThroughput = mbr.getThroughput();
            if (actualThroughput > (float)requestedThroughput || (double)(((float)requestedThroughput - actualThroughput) / (float)requestedThroughput) < 0.02) {
                summary.addPassedRun((long)current, mbr);
                best = current;
                lower = current;
                next = upper == Integer.MAX_VALUE ? (next *= 2) : (next + upper) / 2;
            } else {
                summary.addFailedRun((long)current, mbr);
                upper = current;
                next = (lower + next) / 2;
            }
            LOG.info("target: " + requestedThroughput + " actual: " + actualThroughput + " [" + lower + " " + next + " " + upper + "]");
            for (Map.Entry entry : mbr.getErrors().entrySet()) {
                for (String error : (List)entry.getValue()) {
                    LOG.error(String.format("%s: %s", entry.getKey(), error));
                }
            }
        } while (!((double)((float)Math.abs(current - next) / (float)current) <= 0.02));
        return best;
    }

    private void updateArgValue(List<String> args, String argName, String argValue) {
        int index = args.indexOf(argName);
        if (index == -1) {
            args.add(argName);
            args.add(argValue);
            return;
        }
        if (index + 1 < args.size()) {
            args.set(index + 1, argValue);
        }
    }

    protected abstract S runSingleTest(List<String> var1) throws Exception;
}

