/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.backcompat.ops;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.master.backcompat.FsTestOp;
import alluxio.master.backcompat.Utils;
import org.junit.Assert;

public final class Rename
extends FsTestOp {
    private static final AlluxioURI SRC = new AlluxioURI("/fileToRename");
    private static final AlluxioURI DST = new AlluxioURI("/fileRenameTarget");

    @Override
    public void apply(FileSystem fs) throws Exception {
        Utils.createFile(fs, SRC);
        fs.rename(SRC, DST);
        fs.createDirectory(new AlluxioURI("/renameDir/a/b"), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        fs.rename(new AlluxioURI("/renameDir/a"), new AlluxioURI("/renameDir/c"));
    }

    @Override
    public void check(FileSystem fs) throws Exception {
        Assert.assertFalse((boolean)fs.exists(SRC));
        Assert.assertTrue((boolean)fs.exists(DST));
        Assert.assertFalse((boolean)fs.exists(new AlluxioURI("/renameDir/a")));
        Assert.assertTrue((boolean)fs.exists(new AlluxioURI("/renameDir/c")));
        Assert.assertTrue((boolean)fs.exists(new AlluxioURI("/renameDir/c/b")));
    }
}

