/*
 * Decompiled with CFR 0.152.
 */
package ameba;

import ameba.Application;
import ameba.container.Container;
import ameba.exceptions.AmebaException;
import org.glassfish.hk2.api.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ameba {
    public static final Logger logger = LoggerFactory.getLogger(Ameba.class);
    private static Application app;
    private static Container container;

    private Ameba() {
    }

    public static ServiceLocator getServiceLocator() {
        return container.getServiceLocator();
    }

    public static Application getApp() {
        return app;
    }

    public static void main(String[] args) throws Exception {
        Ameba.bootstrap();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                Ameba.shutdown();
            }
        }, "shutdownHook"));
        Thread.currentThread().join();
    }

    public static void bootstrap() throws Exception {
        Ameba.bootstrap(new Application());
    }

    public static synchronized void bootstrap(Application application) throws Exception {
        if (container != null) {
            throw new AmebaException("\u65e0\u6cd5\u542f\u52a8\u591a\u4e2a\u5b9e\u4f8b");
        }
        app = application;
        container = Container.create(app);
        logger.info("\u542f\u52a8\u5bb9\u5668...");
        container.start();
    }

    public static synchronized void shutdown() {
        logger.info("\u5173\u95ed\u670d\u52a1\u5668...");
        try {
            container.shutdown();
        }
        catch (Exception e) {
            logger.error("\u670d\u52a1\u5668\u5173\u95ed\u51fa\u9519", (Throwable)e);
        }
        logger.info("\u670d\u52a1\u5668\u5df2\u5173\u95ed");
    }
}

