/*
 * Decompiled with CFR 0.152.
 */
package ameba;

import ameba.Ameba;
import ameba.event.Event;
import ameba.event.SystemEventBus;
import ameba.exceptions.AmebaException;
import ameba.exceptions.ConfigErrorException;
import ameba.exceptions.FrostAppCanNotChange;
import ameba.feature.AmebaFeature;
import ameba.server.Connector;
import ameba.util.IOUtils;
import ameba.util.LinkedProperties;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.gaffer.GafferUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

@Singleton
public class Application
extends ResourceConfig {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    protected boolean jmxEnabled;
    private String configFile;
    private Mode mode;
    private String applicationVersion;
    private File sourceRoot;
    private File packageRoot;
    private Container container;
    private List<Connector> connectors = Lists.newArrayList();
    private boolean frost = false;

    public Application() {
        this("conf/application.conf");
    }

    public Application(String confFile) {
        if (Ameba.getApp() != null) {
            throw new AmebaException("\u5df2\u7ecf\u5b58\u5728\u4e00\u4e2a\u5e94\u7528\u5b9e\u4f8b");
        }
        this.configFile = confFile;
        logger.info("\u521d\u59cb\u5316...");
        LinkedHashMap configMap = Maps.newLinkedHashMap();
        LinkedProperties properties = new LinkedProperties();
        logger.info("\u8bfb\u53d6\u7cfb\u7edf\u9ed8\u8ba4\u914d\u7f6e...");
        try {
            properties.load(IOUtils.getResourceAsStream((String)"conf/default.conf"));
            configMap.putAll(properties);
        }
        catch (Exception e) {
            logger.warn("\u8bfb\u53d6[conf/default.conf]\u51fa\u9519", (Throwable)e);
        }
        logger.info("\u8bfb\u53d6\u5e94\u7528\u81ea\u5b9a\u4e49\u914d\u7f6e...");
        this.readAppConfig((Properties)properties, confFile);
        try {
            this.mode = Mode.valueOf(properties.getProperty("app.mode").toUpperCase());
        }
        catch (Exception e) {
            this.mode = Mode.PRODUCT;
        }
        this.setApplicationName(StringUtils.defaultString((String)properties.getProperty("app.name"), (String)"ameba"));
        this.applicationVersion = properties.getProperty("app.version");
        this.configureLogger();
        AmebaFeature.preConfigure(this);
        this.readModeConfig(configMap);
        this.configureConnector((Properties)properties);
        this.readModuleConfig(configMap);
        if (properties.size() > 0) {
            configMap.putAll(properties);
        }
        this.convertJerseyConfig(configMap);
        this.addProperties(configMap);
        this.configureResource(configMap);
        this.configureFeature(configMap);
        this.configureServer((Properties)properties);
        configMap.clear();
        configMap = null;
        properties.clear();
        properties = null;
        Application.publishEvent(new ConfiguredEvent(this));
        this.frost = true;
        logger.info("\u88c5\u8f7d\u7279\u6027...");
    }

    private static void publishEvent(Event event) {
        SystemEventBus.publish(event);
        AmebaFeature.getEventBus().publish(event);
    }

    private void preConfigureFeature(Class clazz) {
        if (AmebaFeature.class.isAssignableFrom(clazz)) {
            try {
                Method m = clazz.getMethod("preConfigure", Application.class);
                if (Modifier.isStatic(m.getModifiers())) {
                    m.invoke(null, new Object[]{this});
                }
            }
            catch (IllegalAccessException e) {
                logger.warn("\u524d\u671f\u521d\u59cb\u5316\u7279\u6027\u51fa\u9519[" + clazz.getName() + "]", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.warn("\u524d\u671f\u521d\u59cb\u5316\u7279\u6027\u51fa\u9519[" + clazz.getName() + "]", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.trace(clazz.getName() + " \u7c7b\u672a\u53d1\u73b0\u9700\u8981\u524d\u671f\u914d\u7f6e\u9879");
            }
        }
    }

    private void configureFeature(Map<String, Object> configMap) {
        Class<?> clazz;
        logger.info("\u6ce8\u518c\u7279\u6027");
        String registerStr = StringUtils.deleteWhitespace((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)this.getProperty("app.registers")), (CharSequence)"")));
        int suc = 0;
        int fail = 0;
        int beak = 0;
        if (StringUtils.isNotBlank((CharSequence)registerStr)) {
            String[] registers;
            for (String register : registers = registerStr.split(",")) {
                try {
                    logger.debug("\u6ce8\u518c\u7279\u6027[{}]", (Object)register);
                    clazz = this.getClassLoader().loadClass(register);
                    if (this.isRegistered(clazz)) {
                        ++beak;
                        logger.warn("\u5e76\u672a\u6ce8\u518c\u7279\u6027[{}]\uff0c\u56e0\u4e3a\u8be5\u7279\u6027\u5df2\u5b58\u5728", (Object)register);
                        continue;
                    }
                    this.preConfigureFeature(clazz);
                    this.register(clazz);
                    ++suc;
                }
                catch (ClassNotFoundException e) {
                    ++fail;
                    if (!register.startsWith("default.")) {
                        logger.error("\u83b7\u53d6\u7279\u6027\u5931\u8d25", (Throwable)e);
                        continue;
                    }
                    logger.warn("\u672a\u627e\u5230\u7cfb\u7edf\u9ed8\u8ba4\u7279\u6027[" + register + "]", (Throwable)e);
                }
            }
        }
        for (String key : configMap.keySet()) {
            String className;
            if (!key.startsWith("app.register.") || !StringUtils.isNotBlank((CharSequence)(className = (String)this.getProperty(key)))) continue;
            String name = key.replaceFirst("^app\\.register\\.", "");
            try {
                logger.debug("\u6ce8\u518c\u7279\u6027[{}({})]", (Object)name, (Object)className);
                clazz = this.getClassLoader().loadClass(className);
                if (this.isRegistered(clazz)) {
                    ++beak;
                    logger.warn("\u5e76\u672a\u6ce8\u518c\u88c5\u7279\u6027[{}({})]\uff0c\u56e0\u4e3a\u8be5\u7279\u6027\u5df2\u5b58\u5728", (Object)name, clazz);
                    continue;
                }
                this.preConfigureFeature(clazz);
                this.register(clazz);
                ++suc;
            }
            catch (ClassNotFoundException e) {
                ++fail;
                if (!name.startsWith("default.")) {
                    logger.error("\u83b7\u53d6\u7279\u6027\u5931\u8d25", (Throwable)e);
                    continue;
                }
                logger.warn("\u672a\u627e\u5230\u7cfb\u7edf\u9ed8\u8ba4\u7279\u6027[" + className + "]", (Throwable)e);
            }
        }
        logger.info("\u6210\u529f\u6ce8\u518c{}\u4e2a\u7279\u6027\uff0c\u5931\u8d25{}\u4e2a\uff0c\u8df3\u8fc7{}\u4e2a", new Object[]{suc, fail, beak});
    }

    private void configureResource(Map<String, Object> configMap) {
        Object[] packages = StringUtils.deleteWhitespace((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)this.getProperty("resource.packages")), (CharSequence)""))).split(",");
        for (String key : configMap.keySet()) {
            String[] pkgs;
            String pkgStr;
            if (!key.startsWith("resource.packages.") || !StringUtils.isNotBlank((CharSequence)(pkgStr = (String)configMap.get(key)))) continue;
            for (String pkg : pkgs = StringUtils.deleteWhitespace((String)pkgStr).split(",")) {
                if (ArrayUtils.contains((Object[])packages, (Object)pkg)) continue;
                packages = (String[])ArrayUtils.add((Object[])packages, (Object)pkg);
            }
        }
        packages = (String[])ArrayUtils.removeElement((Object[])packages, (Object)"");
        logger.info("\u8bbe\u7f6e\u8d44\u6e90\u626b\u63cf\u5305:{}", (Object)StringUtils.join((Object[])packages, (String)","));
        this.registerFinder((ResourceFinder)new PackageNamesScanner(this.getClassLoader(), (String[])packages, true));
    }

    private void convertJerseyConfig(Map<String, Object> configMap) {
        Field[] declaredFields = ServerProperties.class.getDeclaredFields();
        LinkedHashMap staticFieldsMap = Maps.newLinkedHashMap();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            staticFieldsMap.put(field.getName(), field);
        }
        ArrayList removeKeys = Lists.newArrayList();
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (String key : configMap.keySet()) {
            if (!key.startsWith("app.")) continue;
            String name = key.substring(key.indexOf(".") + 1);
            Field filed = (Field)staticFieldsMap.get(name = name.replaceAll("\\.", "_").toUpperCase());
            if (null == filed) continue;
            filed.setAccessible(true);
            try {
                map.put((String)filed.get(null), configMap.get(key));
                removeKeys.add(key);
            }
            catch (IllegalAccessException e) {
                logger.error("\u65e0\u6cd5\u83b7\u53d6\u8bbe\u7f6e\u7684\u952e\u503c", (Throwable)e);
            }
        }
        for (String key : removeKeys) {
            configMap.remove(key);
        }
        configMap.putAll(map);
        map.clear();
        map = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readModeConfig(Map<String, Object> configMap) {
        LinkedProperties modeProperties = new LinkedProperties();
        Enumeration confs = IOUtils.getResources((String)("conf/" + this.mode.name().toLowerCase() + ".conf"));
        while (confs.hasMoreElements()) {
            InputStream in = null;
            try {
                in = ((URL)confs.nextElement()).openStream();
                modeProperties.load(in);
            }
            catch (IOException e) {
                try {
                    logger.warn("\u8bfb\u53d6[conf/" + this.mode.name().toLowerCase() + ".conf]\u51fa\u9519", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                continue;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        if (modeProperties.size() > 0) {
            configMap.putAll((Map<String, Object>)modeProperties);
        }
        modeProperties.clear();
        modeProperties = null;
    }

    private void configureConnector(Properties properties) {
        LinkedHashMap propertiesMap = Maps.newLinkedHashMap();
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("app.connector.")) continue;
            String oKey = key;
            int index = (key = key.replaceFirst("^app\\.connector\\.", "")).indexOf(".");
            if (index == -1) {
                throw new ConfigErrorException("connector configure error, format app.connector.{connectorName}.{property}");
            }
            String name = key.substring(0, index);
            Properties pr = (Properties)propertiesMap.get(name);
            if (pr == null) {
                pr = new Properties();
                propertiesMap.put(name, pr);
                pr.setProperty("name", name);
            }
            pr.setProperty(key.substring(index + 1), properties.getProperty(oKey));
        }
        for (Properties prop : propertiesMap.values()) {
            this.connectors.add(this.createConnector(prop));
        }
    }

    private Connector createConnector(Properties properties) {
        String trustStoreFile;
        Connector.Builder builder = Connector.Builder.create().rawProperties(properties).secureEnabled(Boolean.parseBoolean(properties.getProperty("ssl.enabled", "false"))).sslProtocol(properties.getProperty("ssl.protocol")).sslClientMode(Boolean.parseBoolean(properties.getProperty("ssl.clientMode", "false"))).sslNeedClientAuth(Boolean.parseBoolean(properties.getProperty("ssl.needClientAuth", "false"))).sslWantClientAuth(Boolean.parseBoolean(properties.getProperty("ssl.wantClientAuth", "false"))).sslKeyManagerFactoryAlgorithm(properties.getProperty("ssl.key.manager.factory.algorithm")).sslKeyPassword(properties.getProperty("ssl.key.password")).sslKeyStoreProvider(properties.getProperty("ssl.key.store.provider")).sslKeyStoreType(properties.getProperty("ssl.key.store.type")).sslKeyStorePassword(properties.getProperty("ssl.key.store.password")).sslTrustManagerFactoryAlgorithm(properties.getProperty("ssl.Trust.manager.factory.algorithm")).sslTrustPassword(properties.getProperty("ssl.trust.password")).sslTrustStoreProvider(properties.getProperty("ssl.trust.store.provider")).sslTrustStoreType(properties.getProperty("ssl.trust.store.type")).sslTrustStorePassword(properties.getProperty("ssl.trust.store.password")).ajpEnabled(Boolean.parseBoolean(properties.getProperty("ajp.enabled", "false"))).host((String)StringUtils.defaultIfBlank((CharSequence)properties.getProperty("host"), (CharSequence)"0.0.0.0")).port(Integer.valueOf((String)StringUtils.defaultIfBlank((CharSequence)properties.getProperty("port"), (CharSequence)"80"))).name(properties.getProperty("name"));
        String keyStoreFile = properties.getProperty("ssl.key.store.file");
        if (StringUtils.isNotBlank((CharSequence)keyStoreFile)) {
            try {
                builder.sslKeyStoreFile(IOUtils.readByteArrayFromResource((String)keyStoreFile));
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6sslKeyStoreFile\u51fa\u9519", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(trustStoreFile = properties.getProperty("ssl.trust.store.file")))) {
            try {
                builder.sslTrustStoreFile(IOUtils.readByteArrayFromResource((String)trustStoreFile));
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6sslTrustStoreFile\u51fa\u9519", (Throwable)e);
            }
        }
        return builder.build();
    }

    private void configureServer(Properties properties) {
        this.jmxEnabled = Boolean.parseBoolean(properties.getProperty("app.jmx.enabled"));
        this.registerInstances(new Object[]{new ContainerLifecycleListener(){

            public void onStartup(Container container) {
                Application.publishEvent(new ContainerStartupEvent(container, Application.this));
                logger.info("\u5bb9\u5668\u5df2\u542f\u52a8");
                if (Application.this.container == null) {
                    StringBuilder connectorsBuilder = new StringBuilder();
                    for (Connector connector : Application.this.connectors) {
                        connectorsBuilder.append("        ").append(connector.getHttpServerBaseUri()).append("\n");
                    }
                    logger.info("\u670d\u52a1\u5668\u76d1\u542c\u5730\u5740:\n{}", (Object)connectorsBuilder);
                }
                Application.this.container = container;
            }

            public void onReload(Container container) {
                Application.publishEvent(new ContainerReloadEvent(container, Application.this));
                logger.info("\u5bb9\u5668\u91cd\u65b0\u52a0\u8f7d");
            }

            public void onShutdown(Container container) {
                Application.publishEvent(new ContainerShutdownEvent(container, Application.this));
                logger.info("\u5bb9\u5668\u5df2\u5173\u95ed");
            }
        }});
    }

    private String toExternalForm(URL url) {
        try {
            return URLDecoder.decode(url.toExternalForm(), Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return url.toExternalForm();
        }
    }

    private void readModuleConfig(Map<String, Object> configMap) {
        logger.info("\u8bfb\u53d6\u6a21\u5757\u914d\u7f6e...");
        Enumeration moduleUrls = IOUtils.getResources((String)"conf/module.conf");
        LinkedProperties moduleProperties = new LinkedProperties();
        if (moduleUrls.hasMoreElements()) {
            while (moduleUrls.hasMoreElements()) {
                InputStream in = null;
                URL url = (URL)moduleUrls.nextElement();
                try {
                    String modelName = url.getFile();
                    int jarFileIndex = modelName.lastIndexOf("!");
                    if (jarFileIndex != -1) {
                        modelName = modelName.substring(0, jarFileIndex);
                    }
                    if ((jarFileIndex = modelName.lastIndexOf(".")) != -1) {
                        modelName = modelName.substring(0, jarFileIndex);
                    }
                    int fileIndex = modelName.lastIndexOf("/");
                    modelName = modelName.substring(fileIndex + 1);
                    logger.info("\u52a0\u8f7d\u6a21\u5757 {}", (Object)modelName);
                    logger.debug("\u8bfb\u53d6[{}]\u6587\u4ef6\u914d\u7f6e", (Object)this.toExternalForm(url));
                    in = url.openStream();
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6[{}]\u51fa\u9519", (Object)this.toExternalForm(url));
                }
                if (in != null) {
                    try {
                        moduleProperties.load(in);
                    }
                    catch (Exception e) {
                        logger.error("\u8bfb\u53d6[{}]\u51fa\u9519", (Object)this.toExternalForm(url));
                    }
                } else {
                    logger.error("\u8bfb\u53d6[{}]\u51fa\u9519", (Object)this.toExternalForm(url));
                }
                IOUtils.closeQuietly(in);
            }
            configMap.putAll((Map<String, Object>)moduleProperties);
            moduleProperties.clear();
            moduleProperties = null;
        } else {
            logger.info("\u672a\u627e\u5230\u9644\u52a0\u6a21\u5757");
        }
    }

    private void readAppConfig(Properties properties, String confFile) {
        Enumeration urls = IOUtils.getResources((String)confFile);
        if (urls.hasMoreElements()) {
            InputStream in = null;
            URL url = (URL)urls.nextElement();
            try {
                logger.info("\u8bfb\u53d6[{}]\u6587\u4ef6\u914d\u7f6e", (Object)this.toExternalForm(url));
                in = url.openStream();
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6[{}]\u51fa\u9519", (Object)this.toExternalForm(url));
            }
            if (in != null) {
                try {
                    properties.load(in);
                }
                catch (Exception e) {
                    logger.error("\u8bfb\u53d6[{}]\u51fa\u9519", (Object)this.toExternalForm(url));
                }
            } else {
                logger.error("\u8bfb\u53d6[{}]\u51fa\u9519", (Object)this.toExternalForm(url));
            }
            IOUtils.closeQuietly((InputStream)in);
            if (urls.hasMoreElements()) {
                ArrayList urlList = Lists.newArrayList((Object[])new String[]{this.toExternalForm(url)});
                while (urls.hasMoreElements()) {
                    urlList.add(((URL)urls.nextElement()).toExternalForm());
                }
                String errorMsg = "\u5b58\u5728\u591a\u4e2a\u7a0b\u5e8f\u914d\u7f6e,\u8bf7\u4f7f\u7528\u552f\u4e00\u7684\u7a0b\u5e8f\u914d\u7f6e\u6587\u4ef6:\n" + StringUtils.join((Iterable)urlList, (String)"\n");
                logger.error(errorMsg);
                throw new ConfigErrorException(errorMsg);
            }
        } else {
            logger.warn("\u672a\u627e\u5230{}\u6587\u4ef6,\u8bf7\u4f55\u5b9e", (Object)confFile);
        }
    }

    public void reload() {
        this.container.reload();
    }

    public void reload(ResourceConfig configuration) {
        this.container.reload(configuration);
    }

    public File getPackageRoot() {
        return this.packageRoot;
    }

    public void setPackageRoot(File packageRoot) {
        this.packageRoot = packageRoot;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public File getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(File sourceRoot) {
        this.checkFrost();
        this.sourceRoot = sourceRoot;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public List<Connector> getConnectors() {
        return this.connectors;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    private void checkFrost() {
        if (this.frost) {
            throw new FrostAppCanNotChange("\u5e94\u7528\u914d\u7f6e\u4e0d\u80fd\u5728\u6b64\u523b\u66f4\u6539");
        }
    }

    private void configureLogger() {
        Handler[] handlers;
        URL loggerConfigFile = IOUtils.getResource((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)this.getProperty("logger.config.file")), (CharSequence)"conf/logback.groovy")));
        if (loggerConfigFile == null) {
            loggerConfigFile = IOUtils.getResource((String)("conf/logback-" + this.getMode().name().toLowerCase() + ".groovy"));
        }
        if (loggerConfigFile != null) {
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            context.reset();
            context.putProperty("appName", this.getApplicationName());
            String appPackage = (String)this.getProperty("app.package");
            context.putProperty("appPackage", appPackage);
            GafferUtil.runGafferConfiguratorOn((LoggerContext)context, (Object)((Object)this), (URL)loggerConfigFile);
        }
        java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        SLF4JBridgeHandler.install();
        rootLogger.setLevel(Level.ALL);
    }

    public static class ContainerShutdownEvent
    extends Event {
        Container container;
        Application app;

        public ContainerShutdownEvent(Container container, Application app) {
            this.container = container;
            this.app = app;
        }

        Container getContainer() {
            return this.container;
        }

        public Application getApp() {
            return this.app;
        }
    }

    public static class ContainerReloadEvent
    extends Event {
        private Container container;
        private Application app;

        public ContainerReloadEvent(Container container, Application app) {
            this.container = container;
            this.app = app;
        }

        Container getContainer() {
            return this.container;
        }

        public Application getApp() {
            return this.app;
        }
    }

    public static class ContainerStartupEvent
    extends Event {
        private Container container;
        private Application app;

        public ContainerStartupEvent(Container container, Application app) {
            this.container = container;
            this.app = app;
        }

        Container getContainer() {
            return this.container;
        }

        public Application getApp() {
            return this.app;
        }
    }

    public static class ConfiguredEvent
    extends Event {
        private Application app;

        public ConfiguredEvent(Application app) {
            this.app = app;
        }

        public Application getApp() {
            return this.app;
        }
    }

    public static enum Mode {
        DEV,
        PRODUCT,
        TEST;


        public boolean isDev() {
            return this == DEV;
        }

        public boolean isProd() {
            return this == PRODUCT;
        }

        public boolean isTest() {
            return this == TEST;
        }
    }
}

