/*
 * Decompiled with CFR 0.152.
 */
package ameba.compiler;

import ameba.Application;
import ameba.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JavaSource {
    public static final String CLASS_EXTENSION = ".class";
    public static final String JAVA_EXTENSION = ".java";
    public static final String JAVA_FILE_ENCODING = "utf-8";
    private final String qualifiedClassName;
    private final File outputDir;
    private final File javaFile;
    private final File classFile;
    private final File inputDir;
    private String sourceCode;
    private byte[] byteCode;

    public JavaSource(String qualifiedClassName, File inputDir, File outputDir) {
        this.qualifiedClassName = qualifiedClassName;
        this.outputDir = outputDir;
        this.inputDir = inputDir;
        String fileName = qualifiedClassName.replaceAll("\\.", "/");
        this.javaFile = new File(inputDir, fileName + JAVA_EXTENSION);
        this.classFile = new File(outputDir, fileName + CLASS_EXTENSION);
    }

    public static File getJava(String name, Application app) {
        File javaFile;
        String fileName = name;
        if (fileName.contains("$")) {
            fileName = fileName.substring(0, fileName.indexOf("$"));
        }
        fileName = fileName.replaceAll("\\.", "/") + JAVA_EXTENSION;
        File pkgRoot = app.getPackageRoot();
        if (pkgRoot != null && (javaFile = new File(pkgRoot, fileName)).exists()) {
            return javaFile;
        }
        return null;
    }

    public JavaSource(String qualifiedClassName, String sourceCode) {
        this(qualifiedClassName, null, new File(IOUtils.getResource((String)"").getFile()));
    }

    public File getInputDir() {
        return this.inputDir;
    }

    public byte[] getByteCode() {
        return this.byteCode;
    }

    public void setByteCode(byte[] byteCode) {
        this.byteCode = byteCode;
    }

    public void clean() {
        if (this.javaFile.exists()) {
            this.javaFile.delete();
        }
        if (this.classFile.exists()) {
            this.classFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJavaFile() throws IOException {
        this.javaFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(this.javaFile);
        try {
            ((OutputStream)out).write(this.sourceCode.getBytes(JAVA_FILE_ENCODING));
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveClassFile() throws IOException {
        this.classFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(this.classFile);
        try {
            ((OutputStream)out).write(this.byteCode);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public String getClassName() {
        return this.qualifiedClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceCode() {
        if (this.sourceCode == null) {
            JavaSource javaSource = this;
            synchronized (javaSource) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(this.getJavaFile());
                    this.sourceCode = IOUtils.read((InputStream)in);
                }
                catch (FileNotFoundException e) {
                    IOUtils.closeQuietly(in);
                }
            }
        }
        return this.sourceCode;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public File getJavaFile() {
        return this.javaFile;
    }

    public File getClassFile() {
        return this.classFile;
    }
}

