/*
 * Decompiled with CFR 0.152.
 */
package ameba.compiler;

import ameba.compiler.CompileErrorException;
import ameba.compiler.JavaCompiler;
import ameba.compiler.JavaSource;
import ameba.util.ClassUtils;
import ameba.util.UnsafeByteArrayInputStream;
import ameba.util.UnsafeByteArrayOutputStream;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkCompiler
extends JavaCompiler {
    final Logger logger = LoggerFactory.getLogger(JdkCompiler.class);
    private final boolean isJdk6;
    private final DiagnosticCollector<JavaFileObject> diagnosticCollector;
    private javax.tools.JavaCompiler jc;
    private JavaFileManagerImpl fileManager;
    private List<String> options;
    private ClassLoaderImpl _classLoader;

    public JdkCompiler() {
        String version = System.getProperty("java.version");
        this.isJdk6 = version != null && version.contains("1.6.");
        this.diagnosticCollector = new DiagnosticCollector();
    }

    @Override
    protected void initialize() {
        ServiceLoader<javax.tools.JavaCompiler> serviceLoader;
        Iterator<javax.tools.JavaCompiler> iterator;
        this.jc = ToolProvider.getSystemJavaCompiler();
        if (this.jc == null && (iterator = (serviceLoader = ServiceLoader.load(javax.tools.JavaCompiler.class)).iterator()).hasNext()) {
            this.jc = iterator.next();
        }
        if (this.jc == null) {
            throw new IllegalStateException("Can't get system java compiler. Please add jdk tools.jar to your classpath.");
        }
        StandardJavaFileManager standardJavaFileManager = this.jc.getStandardFileManager(this.diagnosticCollector, null, null);
        this.options = Arrays.asList("-encoding", "utf-8", "-g", "-nowarn", "-source", "1.6", "-target", "1.6");
        this.setDefaultClasspath(standardJavaFileManager);
        this._classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoaderImpl>(){

            @Override
            public ClassLoaderImpl run() {
                return new ClassLoaderImpl(JdkCompiler.this.classLoader.getParent());
            }
        });
        this.fileManager = new JavaFileManagerImpl(standardJavaFileManager, this._classLoader);
    }

    private void setDefaultClasspath(StandardJavaFileManager fileManager) {
        ClassLoader contextClassLoader = ClassUtils.getContextClassLoader();
        List classpath = ClassUtils.getClasspathURLs((ClassLoader)contextClassLoader);
        if (classpath.size() > 0) {
            try {
                LinkedHashSet<File> files = new LinkedHashSet<File>(classpath.size() + 16);
                for (URL url : classpath) {
                    File file = new File(url.getFile());
                    if (!file.exists()) continue;
                    files.add(file);
                }
                Iterable<? extends File> list = fileManager.getLocation(StandardLocation.CLASS_PATH);
                for (File file : list) {
                    files.add(file);
                }
                fileManager.setLocation(StandardLocation.CLASS_PATH, files);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void generateJavaClass(JavaSource ... source) {
        this.generateJavaClass(Arrays.asList(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateJavaClass(List<JavaSource> sources) {
        Boolean result;
        Object name;
        if (sources == null || sources.size() == 0) {
            throw new IllegalArgumentException("java source list is blank");
        }
        ArrayList fileList = Lists.newArrayList();
        for (JavaSource js : sources) {
            name = js.getClassName();
            int i = ((String)name).lastIndexOf(46);
            String packageName = i < 0 ? "" : ((String)name).substring(0, i);
            String className = i < 0 ? name : ((String)name).substring(i + 1);
            JavaFileObjectImpl javaFileObject = new JavaFileObjectImpl(js);
            this.fileManager.putFileForInput(StandardLocation.SOURCE_PATH, packageName, className + ".java", javaFileObject);
            fileList.add(javaFileObject);
        }
        JavaCompiler.CompilationTask task = this.jc.getTask(null, this.fileManager, this.diagnosticCollector, this.options, null, fileList);
        if (this.isJdk6) {
            name = this;
            synchronized (name) {
                result = task.call();
            }
        } else {
            result = task.call();
        }
        if (result == null || !result.booleanValue()) {
            ArrayList stackTraceElements = Lists.newArrayList();
            for (Diagnostic<JavaFileObject> dia : this.diagnosticCollector.getDiagnostics()) {
                if (!dia.getKind().equals((Object)Diagnostic.Kind.ERROR)) continue;
                JavaFileObjectImpl javaFileObject = (JavaFileObjectImpl)this.diagnosticCollector.getDiagnostics().get(0).getSource();
                JavaSource javaSource = javaFileObject.getJavaSource();
                stackTraceElements.add(new StackTraceElement(javaSource.getClassName(), javaSource.getSourceCode().substring(Integer.valueOf(String.valueOf(dia.getStartPosition())), Integer.valueOf(String.valueOf(dia.getEndPosition()))), javaSource.getClassFile().getName(), Integer.valueOf(String.valueOf(dia.getLineNumber()))));
            }
            CompileErrorException ex = new CompileErrorException("\u7f16\u8bd1\u51fa\u9519!");
            ex.setStackTrace(stackTraceElements.toArray(new StackTraceElement[stackTraceElements.size()]));
            throw ex;
        }
        for (JavaSource js : sources) {
            try {
                this._classLoader.findClass(js.getClassName());
            }
            catch (ClassNotFoundException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private final class ClassLoaderImpl
    extends ClassLoader {
        private final Map<String, JavaFileObject> classes;

        ClassLoaderImpl(ClassLoader parentClassLoader) {
            super(parentClassLoader);
            this.classes = new HashMap<String, JavaFileObject>();
        }

        Collection<JavaFileObject> files() {
            return Collections.unmodifiableCollection(this.classes.values());
        }

        @Override
        protected Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(qualifiedClassName);
            if (c != null) {
                return c;
            }
            JavaFileObject file = this.classes.get(qualifiedClassName);
            if (file != null) {
                byte[] bytes = ((JavaFileObjectImpl)file).getByteCode();
                return this.defineClass(qualifiedClassName, bytes, 0, bytes.length);
            }
            return super.findClass(qualifiedClassName);
        }

        void add(String qualifiedClassName, JavaFileObject file) {
            this.classes.put(qualifiedClassName, file);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            String qualifiedClassName;
            JavaFileObjectImpl file;
            if (name.endsWith(".class") && (file = (JavaFileObjectImpl)this.classes.get(qualifiedClassName = name.substring(0, name.length() - ".class".length()).replace('/', '.'))) != null) {
                return new UnsafeByteArrayInputStream(file.getByteCode());
            }
            return super.getResourceAsStream(name);
        }
    }

    private static final class JavaFileManagerImpl
    extends ForwardingJavaFileManager<JavaFileManager> {
        private final ClassLoaderImpl classLoader;
        private final Map<URI, JavaFileObject> fileObjects = new HashMap<URI, JavaFileObject>();

        public JavaFileManagerImpl(JavaFileManager fileManager, ClassLoaderImpl classLoader) {
            super(fileManager);
            this.classLoader = classLoader;
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            FileObject o = this.fileObjects.get(this.uri(location, packageName, relativeName));
            if (o != null) {
                return o;
            }
            return super.getFileForInput(location, packageName, relativeName);
        }

        public void putFileForInput(StandardLocation location, String packageName, String relativeName, JavaFileObjectImpl file) {
            URI uri = this.uri(location, packageName, relativeName);
            this.fileObjects.put(uri, file);
        }

        private URI uri(JavaFileManager.Location location, String packageName, String relativeName) {
            return ClassUtils.toURI((String)(location.getName() + '/' + packageName + '/' + relativeName));
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
            JavaSource javaSource = null;
            if (outputFile instanceof JavaFileObjectImpl) {
                javaSource = ((JavaFileObjectImpl)outputFile).getJavaSource();
            }
            if (outputFile == null) {
                int index = qualifiedName.lastIndexOf(".");
                String pkg = qualifiedName.substring(0, index);
                String name = qualifiedName.substring(index + 1);
                if (name.contains("$")) {
                    name = name.substring(0, name.indexOf("$"));
                }
                URI uri = this.uri(StandardLocation.SOURCE_PATH, pkg, name + ".java");
                javaSource = ((JavaFileObjectImpl)this.fileObjects.get(uri)).getJavaSource();
            }
            JavaFileObjectImpl file = new JavaFileObjectImpl(javaSource, qualifiedName, kind);
            this.classLoader.add(qualifiedName, file);
            return file;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.classLoader;
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
            if (file instanceof JavaFileObjectImpl) {
                return file.getName();
            }
            return super.inferBinaryName(loc, file);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
            if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
                for (JavaFileObject file : this.fileObjects.values()) {
                    if (file.getKind() != JavaFileObject.Kind.CLASS || !file.getName().startsWith(packageName)) continue;
                    files.add(file);
                }
                files.addAll(this.classLoader.files());
            } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
                for (JavaFileObject file : this.fileObjects.values()) {
                    if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                    files.add(file);
                }
            }
            Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
            for (JavaFileObject file : result) {
                files.add(file);
            }
            return files;
        }
    }

    private static final class JavaFileObjectImpl
    extends SimpleJavaFileObject {
        private final JavaSource source;
        private UnsafeByteArrayOutputStream bytecode;

        public JavaFileObjectImpl(JavaSource source) {
            super(source.getJavaFile().toURI(), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        public JavaFileObjectImpl(JavaSource source, String baseName, JavaFileObject.Kind k) {
            super(ClassUtils.toURI((String)baseName), k);
            this.source = source;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws UnsupportedOperationException {
            if (this.source == null || this.source.getSourceCode() == null) {
                throw new UnsupportedOperationException("source == null");
            }
            return this.source.getSourceCode();
        }

        public JavaSource getJavaSource() {
            return this.source;
        }

        @Override
        public InputStream openInputStream() {
            return new UnsafeByteArrayInputStream(this.getByteCode());
        }

        @Override
        public OutputStream openOutputStream() {
            this.bytecode = new UnsafeByteArrayOutputStream();
            return this.bytecode;
        }

        public byte[] getByteCode() {
            byte[] bytes = this.bytecode.toByteArray();
            if (this.source != null) {
                this.source.setByteCode(bytes);
            }
            return bytes;
        }
    }
}

