/*
 * Decompiled with CFR 0.152.
 */
package ameba.compiler;

import ameba.compiler.CompileErrorException;
import ameba.compiler.JavaCompiler;
import ameba.compiler.JavaSource;
import ameba.util.ClassUtils;
import ameba.util.IOUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdtCompiler
extends JavaCompiler {
    @Override
    public void generateJavaClass(JavaSource ... source) {
        this.generateJavaClass(Arrays.asList(source));
    }

    @Override
    public void generateJavaClass(List<JavaSource> sources) {
        if (sources == null || sources.size() == 0) {
            throw new IllegalArgumentException("java source list is blank");
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        CompilerOptions options = this.getCompilerOptions();
        CompilerRequestor requestor = new CompilerRequestor(sources);
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilationUnit[] compilationUnits = new ICompilationUnit[sources.size()];
        for (JavaSource source : sources) {
            compilationUnits[compilationUnits.length] = new CompilationUnit(source);
        }
        Compiler compiler = new Compiler((INameEnvironment)new NameEnvironment(sources), policy, options, (ICompilerRequestor)requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        if (requestor.hasErrors()) {
            throw new CompileErrorException("\u7f16\u8bd1\u51fa\u9519!");
        }
    }

    private CompilerOptions getCompilerOptions() {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        settings.put("org.eclipse.jdt.core.encoding", "utf-8");
        settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        settings.put("org.eclipse.jdt.core.compiler.source", "1.6");
        settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
        settings.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
        CompilerOptions options = new CompilerOptions(settings);
        options.parseLiteralExpressionsAsConstants = true;
        return options;
    }

    static class CompilerRequestor
    implements ICompilerRequestor {
        IProblem[] errors;
        List<JavaSource> sources;
        Map<String, JavaSource> map;

        CompilerRequestor(List<JavaSource> sources) {
            this.sources = sources;
            this.map = Maps.newHashMap();
            for (JavaSource js : sources) {
                this.map.put(js.getClassName(), js);
            }
        }

        public void acceptResult(CompilationResult result) {
            if (result.hasErrors()) {
                this.errors = result.getErrors();
            } else {
                ClassFile[] classFiles;
                for (ClassFile classFile : classFiles = result.getClassFiles()) {
                    char[][] compoundName = classFile.getCompoundName();
                    String className = "";
                    String sep = "";
                    for (char[] aCompoundName : compoundName) {
                        className = className + sep;
                        className = className + new String(aCompoundName);
                        sep = ".";
                    }
                    byte[] bytes = classFile.getBytes();
                    this.map.get(className).setByteCode(bytes);
                }
            }
        }

        public boolean hasErrors() {
            return this.errors != null;
        }

        public IProblem[] getErrors() {
            return this.errors;
        }
    }

    static class NameEnvironment
    implements INameEnvironment {
        static final Logger log = LoggerFactory.getLogger(NameEnvironment.class);
        final Map<String, Boolean> cache = new HashMap<String, Boolean>();
        final ClassLoader classLoader;
        final Map<String, JavaSource> map = Maps.newHashMap();

        public NameEnvironment(List<JavaSource> sources) {
            for (JavaSource source : sources) {
                this.map.put(source.getClassName(), source);
            }
            this.classLoader = ClassUtils.getContextClassLoader();
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < compoundTypeName.length; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(compoundTypeName[i]);
            }
            return this.findType(sb.toString());
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            StringBuilder sb = new StringBuilder();
            for (char[] aPackageName : packageName) {
                sb.append(aPackageName).append('.');
            }
            sb.append(typeName);
            return this.findType(sb.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NameEnvironmentAnswer findType(String className) {
            if (this.map.containsKey(className)) {
                return new NameEnvironmentAnswer((ICompilationUnit)new CompilationUnit(this.map.get(className)), null);
            }
            InputStream is = null;
            try {
                String resourceName = className.replace('.', '/') + ".class";
                is = this.classLoader.getResourceAsStream(resourceName);
                if (is != null) {
                    byte[] bytes;
                    try {
                        bytes = IOUtils.toByteArray((InputStream)is);
                    }
                    catch (IOException e) {
                        throw new CompileErrorException(e);
                    }
                    char[] fileName = resourceName.toCharArray();
                    ClassFileReader classFileReader = new ClassFileReader(bytes, fileName, true);
                    NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                    IOUtils.closeQuietly((InputStream)is);
                    return nameEnvironmentAnswer;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (ClassFormatException e) {
                log.error("Compilation error", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(is);
            }
            return null;
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            StringBuilder sb = new StringBuilder();
            if (parentPackageName != null) {
                for (char[] p : parentPackageName) {
                    sb.append(p).append('.');
                }
            }
            sb.append(packageName);
            String name = sb.toString();
            Boolean found = this.cache.get(name);
            if (found != null) {
                return found;
            }
            boolean isPackage = !this.isJavaClass(name);
            this.cache.put(name, isPackage);
            return isPackage;
        }

        private boolean isJavaClass(String name) {
            if (this.map.containsKey(name)) {
                return true;
            }
            String resourceName = name.replace('.', '/') + ".class";
            URL url = this.classLoader.getResource(resourceName);
            return url != null;
        }

        public void cleanup() {
        }
    }

    static class CompilationUnit
    implements ICompilationUnit {
        final JavaSource source;

        public CompilationUnit(JavaSource source) {
            this.source = source;
        }

        public char[] getFileName() {
            return this.source.getJavaFile().getAbsolutePath().toCharArray();
        }

        public char[] getContents() {
            return this.source.getSourceCode().toCharArray();
        }

        public char[] getMainTypeName() {
            String qualifiedClassName = this.source.getClassName();
            int dot = qualifiedClassName.lastIndexOf(46);
            if (dot > 0) {
                return qualifiedClassName.substring(dot + 1).toCharArray();
            }
            return qualifiedClassName.toCharArray();
        }

        public char[][] getPackageName() {
            StringTokenizer tokenizer = new StringTokenizer(this.source.getClassName(), ".");
            char[][] result = new char[tokenizer.countTokens() - 1][];
            for (int i = 0; i < result.length; ++i) {
                String tok = tokenizer.nextToken();
                result[i] = tok.toCharArray();
            }
            return result;
        }

        public boolean ignoreOptionalProblems() {
            return false;
        }
    }
}

