/*
 * Decompiled with CFR 0.152.
 */
package ameba.container;

import ameba.Application;
import ameba.container.ContainerException;
import ameba.util.ClassUtils;
import java.lang.reflect.InvocationTargetException;
import org.glassfish.hk2.api.ServiceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Container {
    public static final Logger logger = LoggerFactory.getLogger(Container.class);
    protected Application application;

    public Container(Application application) {
        this.application = application;
    }

    public static Container create(Application application) throws IllegalAccessException, InstantiationException {
        String provider = (String)application.getProperty("app.container.provider");
        try {
            Container container = (Container)ClassUtils.forName((String)provider).getConstructor(Application.class).newInstance(new Object[]{application});
            return container;
        }
        catch (InvocationTargetException e) {
            throw new ContainerException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ContainerException(e);
        }
        finally {
            logger.info("HTTP\u5bb9\u5668\u4e3a {}", (Object)provider);
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public abstract ServiceLocator getServiceLocator();

    public abstract void start() throws Exception;

    public abstract void shutdown() throws Exception;
}

