/*
 * Decompiled with CFR 0.152.
 */
package ameba.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.sql.DataSource;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
public class DataSourceFeature
implements Feature {
    private static final Map<String, DataSource> dataSourceMap = Maps.newHashMap();
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFeature.class);

    public static DataSource getDataSource(String name) {
        return dataSourceMap.get(name);
    }

    public static Set<String> getDataSourceNames() {
        return dataSourceMap.keySet();
    }

    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        HashMap map = Maps.newHashMap();
        for (String key : config.getPropertyNames()) {
            key = StringUtils.deleteWhitespace((String)key);
            String[] keys = (key = key.replace("\\.{2,}", ".")).split("\\.");
            if (keys.length <= 2 || !"db".equals(keys[0])) continue;
            Map sourceConfig = (Map)map.get(keys[1]);
            if (null == sourceConfig) {
                sourceConfig = Maps.newHashMap();
                map.put(keys[1], sourceConfig);
            }
            if (!StringUtils.isNotBlank((CharSequence)keys[2])) continue;
            sourceConfig.put(keys[2], String.valueOf(config.getProperty(key)));
        }
        dataSourceMap.clear();
        for (String name : map.keySet()) {
            try {
                DataSource ds;
                Map conf = (Map)map.get(name);
                String value = (String)conf.get("init");
                if (StringUtils.isBlank((CharSequence)value)) {
                    conf.put("init", "true");
                }
                if (DruidDataSource.class.isInstance(ds = DruidDataSourceFactory.createDataSource((Map)conf))) {
                    ((DruidDataSource)ds).setName(name);
                }
                dataSourceMap.put(name, ds);
            }
            catch (Exception e) {
                logger.error("\u914d\u7f6e\u6570\u636e\u6e90\u51fa\u9519", (Throwable)e);
            }
        }
        return true;
    }
}

