/*
 * Decompiled with CFR 0.152.
 */
package ameba.db.ebean;

import ameba.db.DataSourceFeature;
import ameba.db.TransactionFeature;
import ameba.db.ebean.EbeanFinder;
import ameba.db.ebean.EbeanPersister;
import ameba.db.ebean.transaction.EbeanTransactional;
import ameba.db.model.Model;
import ameba.enhancers.model.ModelDescription;
import ameba.enhancers.model.ModelManager;
import ameba.util.IOUtils;
import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.enhance.agent.InputStreamTransform;
import com.avaje.ebean.enhance.agent.Transformer;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.ddl.DdlGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import javassist.CannotCompileException;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.FeatureContext;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConstrainedTo(value=RuntimeType.SERVER)
public class EbeanFeature
extends TransactionFeature {
    private static final Logger logger = LoggerFactory.getLogger(EbeanFeature.class);
    private static final int EBEAN_TRANSFORM_LOG_LEVEL = LoggerFactory.getLogger(Ebean.class).isDebugEnabled() ? 9 : 0;

    public EbeanFeature() {
        super(EbeanFinder.class, EbeanPersister.class);
    }

    public static String generateEvolutionScript(EbeanServer server, ServerConfig config, DdlGenerator ddl) {
        ddl.setup((SpiEbeanServer)server, config.getDatabasePlatform(), config);
        String create = ddl.generateCreateDdl();
        String drop = ddl.generateDropDdl();
        if (create == null || create.trim().isEmpty()) {
            return null;
        }
        return "/*--- Created by Ameba DDL */\n\n/*--- !Drop */\n\n" + drop + "\n" + "/*--- !Create */\n" + "\n" + create;
    }

    public static String generateEvolutionScript(EbeanServer server, ServerConfig config) {
        return EbeanFeature.generateEvolutionScript(server, config, new DdlGenerator());
    }

    public static String generateEvolutionScript(String serverName, ServerConfig config) {
        return EbeanFeature.generateEvolutionScript(Ebean.getServer((String)serverName), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] ehModel(ModelDescription desc) throws URISyntaxException, IOException, IllegalClassFormatException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, CannotCompileException {
        Transformer transformer = new Transformer("", "debug=" + EBEAN_TRANSFORM_LOG_LEVEL);
        InputStreamTransform streamTransform = new InputStreamTransform(transformer, Ebean.class.getClassLoader());
        InputStream in = desc.getClassByteCode() != null ? new ByteArrayInputStream(desc.getClassByteCode()) : new URL(desc.getClassFile()).openStream();
        byte[] result = null;
        try {
            result = streamTransform.transform(desc.getClassSimpleName(), in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        if (result == null) {
            logger.debug("{} class not entity.", (Object)desc.getClassName());
            result = desc.getClassByteCode();
        }
        return result;
    }

    public boolean configure(FeatureContext context) {
        context.register(EbeanTransactional.class);
        Configuration appConfig = context.getConfiguration();
        for (String key : appConfig.getPropertyNames()) {
            Object value;
            if (!key.startsWith("model.") || null == (value = appConfig.getProperty(key))) continue;
            GlobalProperties.put((String)key.replaceFirst("model\\.", "ebean."), (String)String.valueOf(value));
        }
        for (String name : DataSourceFeature.getDataSourceNames()) {
            String value;
            ServerConfig config = new ServerConfig();
            config.setPackages(null);
            config.setJars(null);
            config.setName(name);
            boolean isProd = "product".equals(appConfig.getProperty("app.mode"));
            if (!isProd && null != (value = (String)appConfig.getProperty("db." + name + ".debug.lazyLoadSize"))) {
                config.setLazyLoadBatchSize(Integer.valueOf(value).intValue());
            }
            config.setDataSource(DataSourceFeature.getDataSource(name));
            if (name.equals(Model.DB_DEFAULT_SERVER_NAME)) {
                config.setDefaultServer(true);
            }
            ModelManager manager = ModelManager.getManager(name);
            config.setDdlGenerate(false);
            config.setDdlRun(false);
            String value2 = (String)appConfig.getProperty("db." + name + ".ddl.generate");
            boolean genDdl = false;
            if (null != value2) {
                genDdl = Boolean.valueOf(value2);
            }
            value2 = (String)appConfig.getProperty("db." + name + ".ddl.run");
            boolean runDdl = false;
            if (null != value2) {
                runDdl = Boolean.valueOf(value2);
            }
            manager.addModelLoadedListener(new ModelEventListener(config, isProd, genDdl, runDdl));
        }
        return true;
    }

    public static class ModelEventListener
    extends ModelManager.ModelEventListener {
        ServerConfig config;
        boolean isProd;
        boolean runDdl;
        boolean genDdl;

        public ModelEventListener(ServerConfig config, boolean isProd, boolean genDdl, boolean runDdl) {
            this.config = config;
            this.isProd = isProd;
            this.runDdl = runDdl;
            this.genDdl = genDdl;
        }

        @Override
        protected byte[] enhancing(ModelDescription desc) {
            try {
                return EbeanFeature.ehModel(desc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void loaded(Class clazz, ModelDescription desc, int index, int size) {
            this.config.addClass(clazz);
            if (index == size - 1) {
                EbeanServer server = EbeanServerFactory.create((ServerConfig)this.config);
                if (!this.isProd && this.genDdl) {
                    final String basePath = IOUtils.getResource((String)"").getPath() + "conf/evolutions/" + server.getName() + "/";
                    DdlGenerator ddl = new DdlGenerator(){

                        protected String getDropFileName() {
                            return basePath + "drop.sql";
                        }

                        protected String getCreateFileName() {
                            return basePath + "create.sql";
                        }

                        public String generateDropDdl() {
                            return "/* Generated Drop Table DDL By Ameba */\n\n" + super.generateDropDdl();
                        }

                        public String generateCreateDdl() {
                            return "/* Generated Create Table DDL By Ameba */\n\n" + super.generateCreateDdl();
                        }

                        public void generateDdl() {
                            if (ModelEventListener.this.genDdl) {
                                this.writeDrop(this.getDropFileName());
                                this.writeCreate(this.getCreateFileName());
                            }
                        }

                        public void runDdl() {
                            if (ModelEventListener.this.runDdl) {
                                try {
                                    this.runScript(true, this.readFile(this.getDropFileName()));
                                    this.runScript(false, this.readFile(this.getCreateFileName()));
                                }
                                catch (IOException e) {
                                    String msg = "Error reading drop/create script from file system";
                                    throw new RuntimeException(msg, e);
                                }
                            }
                        }
                    };
                    ddl.setup((SpiEbeanServer)server, this.config.getDatabasePlatform(), this.config);
                    try {
                        FileUtils.forceMkdir((File)new File(basePath));
                        ddl.generateDdl();
                        ddl.runDdl();
                    }
                    catch (IOException e) {
                        logger.error("Create ddl error", (Throwable)e);
                    }
                }
            }
        }
    }
}

