/*
 * Decompiled with CFR 0.152.
 */
package ameba.db.model;

import com.avaje.ebean.Filter;
import com.avaje.ebean.Query;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Finder<ID, T>
implements Query<T> {
    private static final Logger logger = LoggerFactory.getLogger(Finder.class);
    private final Class<ID> idType;
    private final Class<T> modelType;
    private final String serverName;

    public Finder(String serverName, Class<ID> idType, Class<T> modelType) {
        if (StringUtils.isBlank((CharSequence)serverName)) {
            throw new IllegalArgumentException("server name is blank");
        }
        if (idType == null) {
            throw new IllegalArgumentException("id model type is null");
        }
        if (modelType == null) {
            throw new IllegalArgumentException("model model type is null");
        }
        this.modelType = modelType;
        this.idType = idType;
        this.serverName = serverName;
    }

    public Class<ID> getIdType() {
        return this.idType;
    }

    public Class<T> getModelType() {
        return this.modelType;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Finder<ID, T> on(String server) {
        try {
            return (Finder)this.getClass().getConstructor(String.class, Class.class, Class.class).newInstance(server, this.idType, this.modelType);
        }
        catch (InstantiationException e) {
            logger.error("Finder.on(server) error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            logger.error("Finder.on(server) error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            logger.error("Finder.on(server) error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("Finder.on(server) error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public abstract List<T> all();

    public abstract T byId(ID var1);

    public abstract T ref(ID var1);

    public abstract Filter<T> filter();

    public abstract Query<T> query();

    public abstract ID nextId();

    public abstract Query<T> setQuery(String var1);
}

