/*
 * Decompiled with CFR 0.152.
 */
package ameba.db.model;

import ameba.db.TransactionFeature;
import ameba.db.model.Finder;
import ameba.db.model.Persister;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang3.NotImplementedException;

@MappedSuperclass
public abstract class Model
implements Serializable {
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private static final HashMap<Class, Finder> FinderMap = Maps.newHashMap();
    @Transient
    private static Constructor<? extends Finder> finderConstructor = null;
    @Transient
    private static Constructor<? extends Persister> persisterConstructor = null;
    @Transient
    private final byte[] lock = new byte[0];
    @Transient
    private Method _idGetter = null;
    @Transient
    private Method _idSetter = null;
    @Transient
    public static String DB_DEFAULT_SERVER_NAME = "default";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transient
    protected static Constructor<? extends Finder> getFinderConstructor() {
        if (finderConstructor != null) return finderConstructor;
        Class<Model> clazz = Model.class;
        synchronized (Model.class) {
            if (finderConstructor != null) return finderConstructor;
            try {
                finderConstructor = TransactionFeature.getFinderClass().getConstructor(String.class, Class.class, Class.class);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return finderConstructor;
        }
    }

    @Transient
    protected static void putFinderCache(Class clzz, Finder finder) {
        FinderMap.put(clzz, finder);
    }

    @Transient
    protected static Finder getFinderCache(Class clzz) {
        return FinderMap.get(clzz);
    }

    @Transient
    protected static <ID, T> Finder<ID, T> _getFinder(String server) {
        throw new NotImplementedException("model not enhanced!");
    }

    @Transient
    public static <ID, T> Finder<ID, T> withFinder(String server) {
        Finder<ID, T> finder = Model._getFinder(server);
        if (finder == null) {
            throw new NotFinderFindException();
        }
        return finder;
    }

    @Transient
    public static <ID, T> Finder<ID, T> withFinder() {
        return Model.withFinder(DB_DEFAULT_SERVER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transient
    protected static Constructor<? extends Persister> getPersisterConstructor() {
        if (persisterConstructor != null) return persisterConstructor;
        Class<Model> clazz = Model.class;
        synchronized (Model.class) {
            if (persisterConstructor != null) return persisterConstructor;
            try {
                persisterConstructor = TransactionFeature.getPersisterClass().getConstructor(String.class, Model.class);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return persisterConstructor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transient
    private Method _getIdGetter() throws NoSuchMethodException {
        if (this._idGetter != null) return this._idGetter;
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this._idGetter != null) return this._idGetter;
            this._idGetter = this.getClass().getDeclaredMethod("__getId__", new Class[0]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._idGetter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transient
    private Method _getIdSetter() throws NoSuchMethodException {
        if (this._idSetter != null) return this._idSetter;
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this._idSetter != null) return this._idSetter;
            this._idSetter = this.getClass().getDeclaredMethod("__setId__", this._getIdGetter().getReturnType());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._idSetter;
        }
    }

    @Transient
    <R> R _getId() {
        try {
            return (R)this._getIdGetter().invoke((Object)this, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Transient
    void _setId(Object id) {
        try {
            this._getIdSetter().invoke((Object)this, id);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Transient
    protected <M extends Model> Persister<M> _getPersister(String server) {
        Persister persister = null;
        try {
            persister = Model.getPersisterConstructor().newInstance(server, this);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return persister;
    }

    @Transient
    public <M extends Model> Persister<M> withPersister(String server) {
        Persister<M> persister = this._getPersister(server);
        if (persister == null) {
            throw new NotPersisterFindException();
        }
        return persister;
    }

    @Transient
    public <M extends Model> Persister<M> withPersister() {
        return this.withPersister(DB_DEFAULT_SERVER_NAME);
    }

    public static class NotFinderFindException
    extends RuntimeException {
        public NotFinderFindException() {
            super("_getFinder method not return Persister instance");
        }
    }

    public static class NotPersisterFindException
    extends RuntimeException {
        public NotPersisterFindException() {
            super("_getPersister method not return Persister instance");
        }
    }
}

