/*
 * Decompiled with CFR 0.152.
 */
package ameba.db.model;

import ameba.db.model.Model;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import javax.persistence.OptimisticLockException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Persister<M extends Model> {
    private static final Logger logger = LoggerFactory.getLogger(Persister.class);
    private M model;
    private String serverName;

    public Persister(String serverName, M model) {
        if (StringUtils.isBlank((CharSequence)serverName)) {
            throw new IllegalArgumentException("server name is blank");
        }
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        this.model = model;
        this.serverName = serverName;
    }

    protected M getModel() {
        return this.model;
    }

    protected String getServerName() {
        return this.serverName;
    }

    public Persister<M> on(String server) {
        try {
            return (Persister)this.getClass().getConstructor(String.class, Model.class).newInstance(server, this.model);
        }
        catch (InstantiationException e) {
            logger.error("Persister.on(server) error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            logger.error("Persister.on(server) error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            logger.error("Persister.on(server) error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("Persister.on(server) error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public abstract void save();

    public abstract void saveManyToManyAssociations(String var1);

    public abstract void deleteManyToManyAssociations(String var1);

    public abstract void update();

    public void update(Object id) {
        ((Model)this.getModel())._setId(id);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        Object id = ((Model)this.getModel())._getId();
        Object otherId = ((Model)other)._getId();
        if (id == null) {
            return false;
        }
        if (otherId == null) {
            return false;
        }
        return id.equals(otherId);
    }

    public int hashCode() {
        Object id = ((Model)this.getModel())._getId();
        return id == null ? super.hashCode() : id.hashCode();
    }

    public abstract void delete();

    public abstract int delete(Class<?> var1, Object var2);

    public abstract void delete(Class<?> var1, Collection<?> var2);

    public abstract int delete(Iterator<?> var1) throws OptimisticLockException;

    public abstract int delete(Collection<?> var1) throws OptimisticLockException;

    public abstract void refresh();

    public abstract void markAsDirty();

    public abstract void insert();
}

