/*
 * Decompiled with CFR 0.152.
 */
package ameba.enhancers;

import java.util.HashMap;
import java.util.Map;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;

public abstract class Enhancer {
    protected ClassPool classPool = Enhancer.newClassPool();

    public static ClassPool newClassPool() {
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        classPool.appendClassPath((ClassPath)new LoaderClassPath(Enhancer.class.getClassLoader()));
        return classPool;
    }

    protected boolean isFinal(CtField ctField) {
        return Modifier.isFinal((int)ctField.getModifiers());
    }

    protected boolean hasAnnotation(CtClass ctClass, String annotation) throws ClassNotFoundException {
        for (Object object : ctClass.getAvailableAnnotations()) {
            java.lang.annotation.Annotation ann = (java.lang.annotation.Annotation)object;
            if (!ann.annotationType().getName().equals(annotation)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnnotation(CtField ctField, String annotation) throws ClassNotFoundException {
        for (Object object : ctField.getAvailableAnnotations()) {
            java.lang.annotation.Annotation ann = (java.lang.annotation.Annotation)object;
            if (!ann.annotationType().getName().equals(annotation)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAnnotation(CtMethod ctMethod, String annotation) throws ClassNotFoundException {
        for (Object object : ctMethod.getAvailableAnnotations()) {
            java.lang.annotation.Annotation ann = (java.lang.annotation.Annotation)object;
            if (!ann.annotationType().getName().equals(annotation)) continue;
            return true;
        }
        return false;
    }

    protected static void createAnnotation(AnnotationsAttribute attribute, Class<? extends java.lang.annotation.Annotation> annotationType, Map<String, MemberValue> members) {
        Annotation annotation = new Annotation(annotationType.getName(), attribute.getConstPool());
        for (Map.Entry<String, MemberValue> member : members.entrySet()) {
            annotation.addMemberValue(member.getKey(), member.getValue());
        }
        attribute.addAnnotation(annotation);
    }

    protected static void createAnnotation(AnnotationsAttribute attribute, Class<? extends java.lang.annotation.Annotation> annotationType) {
        Enhancer.createAnnotation(attribute, annotationType, new HashMap<String, MemberValue>());
    }

    protected static AnnotationsAttribute getAnnotations(CtClass ctClass) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(ctClass.getClassFile().getConstPool(), "RuntimeVisibleAnnotations");
            ctClass.getClassFile().addAttribute((AttributeInfo)annotationsAttribute);
        }
        return annotationsAttribute;
    }

    protected static AnnotationsAttribute getAnnotations(CtField ctField) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctField.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(ctField.getFieldInfo().getConstPool(), "RuntimeVisibleAnnotations");
            ctField.getFieldInfo().addAttribute((AttributeInfo)annotationsAttribute);
        }
        return annotationsAttribute;
    }

    protected boolean isProperty(CtField ctField) {
        return !ctField.getName().equals(ctField.getName().toUpperCase()) && !ctField.getName().substring(0, 1).equals(ctField.getName().substring(0, 1).toUpperCase()) && Modifier.isPublic((int)ctField.getModifiers()) && !Modifier.isStatic((int)ctField.getModifiers()) && Modifier.isPublic((int)ctField.getDeclaringClass().getModifiers());
    }

    protected static AnnotationsAttribute getAnnotations(CtMethod ctMethod) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctMethod.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
        if (annotationsAttribute == null) {
            annotationsAttribute = new AnnotationsAttribute(ctMethod.getMethodInfo().getConstPool(), "RuntimeVisibleAnnotations");
            ctMethod.getMethodInfo().addAttribute((AttributeInfo)annotationsAttribute);
        }
        return annotationsAttribute;
    }

    boolean isAnon(Class clazz) {
        return clazz.getName().contains("$anonfun$") || clazz.getName().contains("$anon$");
    }
}

