/*
 * Decompiled with CFR 0.152.
 */
package ameba.enhancers.model;

import ameba.Application;
import ameba.db.DataSourceFeature;
import ameba.enhancers.model.ModelManager;
import ameba.event.Listener;
import ameba.feature.AmebaFeature;
import javax.inject.Singleton;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
public class EnhanceModelFeature
extends AmebaFeature {
    private static final Logger logger = LoggerFactory.getLogger(EnhanceModelFeature.class);

    public static void preConfigure(final Application app) {
        EnhanceModelFeature.subscribeEvent(Application.ConfiguredEvent.class, new Listener<Application.ConfiguredEvent>(){

            @Override
            public void onReceive(Application.ConfiguredEvent event) {
                if (app.isRegistered(EnhanceModelFeature.class)) {
                    app.register(Enhance.class, Integer.MAX_VALUE);
                }
            }
        });
    }

    public boolean configure(FeatureContext context) {
        ModelManager.reset();
        Configuration config = context.getConfiguration();
        for (String name : DataSourceFeature.getDataSourceNames()) {
            String modelPackages = (String)config.getProperty("db." + name + ".models");
            if (!StringUtils.isNotBlank((CharSequence)modelPackages)) continue;
            logger.debug("\u521b\u5efaModelManager\uff0c[{}:{}]", (Object)name, (Object)modelPackages);
            ModelManager.create(name, modelPackages.split(","));
        }
        return true;
    }

    public static class Enhance
    implements Feature {
        public boolean configure(FeatureContext context) {
            ModelManager.loadAndClearDesc();
            return true;
        }
    }
}

