/*
 * Decompiled with CFR 0.152.
 */
package ameba.enhancers.model;

import ameba.db.model.Model;
import ameba.enhancers.Enhancer;
import ameba.enhancers.EnhancingException;
import ameba.enhancers.model.ModelDescription;
import ameba.exceptions.UnexpectedException;
import ameba.util.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.Modifier;
import javassist.NotFoundException;
import javax.persistence.Id;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelManager
extends Enhancer {
    public static final Logger logger = LoggerFactory.getLogger(ModelManager.class);
    public static final Map<String, ModelManager> managerMap = Maps.newHashMap();
    public static final String ID_SETTER_NAME = "__setId__";
    public static final String ID_GETTER_NAME = "__getId__";
    public static final String GET_FINDER_M_NAME = "withFinder";
    public static final String FINDER_C_NAME = "ameba.db.model.Finder";
    public static final String BASE_MODEL_PKG = "ameba.db.model";
    private static final Map<String, ModelDescription> descCache = Maps.newHashMap();
    private static ClassPool classpool;
    private List<ModelDescription> modelClassesDescList = Lists.newArrayList();
    private List<ModelEventListener> listeners = Lists.newArrayList();
    private String[] packages;

    private ModelManager(String[] packages) {
        this.packages = packages;
    }

    public static void reset() {
        managerMap.clear();
        classpool = ModelManager.newClassPool();
        descCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelManager create(String name, String[] packages) {
        ModelManager manager = ModelManager.getManager(name);
        if (manager == null) {
            Map<String, ModelManager> map = managerMap;
            synchronized (map) {
                if (ModelManager.getManager(name) == null) {
                    manager = new ModelManager(packages);
                    managerMap.put(name, manager);
                }
            }
        }
        return manager;
    }

    private static String decodeClassFile(ModelDescription desc) {
        try {
            return URLDecoder.decode(desc.classFile, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            return desc.classFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAndClearDesc(String name) {
        ModelManager manager = ModelManager.getManager(name);
        if (manager != null) {
            manager.loadClass();
            int size = manager.modelClassesDescList.size();
            int index = 0;
            for (ModelDescription desc : manager.modelClassesDescList) {
                if (desc.clazz == null) {
                    ByteArrayInputStream in = new ByteArrayInputStream(desc.classBytecode);
                    try {
                        logger.debug("load {} model manager class {}", (Object)name, (Object)ModelManager.decodeClassFile(desc));
                        desc.clazz = classpool.makeClass((InputStream)in).toClass();
                        manager.fireModelLoaded(desc.clazz, desc, index, size);
                    }
                    catch (IOException e) {
                        logger.warn("load model class file [" + ModelManager.decodeClassFile(desc) + "] error", (Throwable)e);
                    }
                    catch (CannotCompileException e) {
                        logger.warn("load model class file [" + ModelManager.decodeClassFile(desc) + "] error", (Throwable)e);
                    }
                    finally {
                        ++index;
                        IOUtils.closeQuietly((InputStream)in);
                    }
                } else {
                    manager.fireModelLoaded(desc.clazz, desc, index, size);
                    ++index;
                }
                logger.debug("clear {} model manager class {} desc", (Object)name, (Object)ModelManager.decodeClassFile(desc));
                desc.classBytecode = null;
            }
        }
    }

    public static void loadAndClearDesc() {
        Set<String> keys = managerMap.keySet();
        for (String key : keys) {
            ModelManager.loadAndClearDesc(key);
        }
        descCache.clear();
    }

    public static ModelManager getManager(String name) {
        return managerMap.get(name);
    }

    public void addModelLoadedListener(ModelEventListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireModelLoaded(Class clazz, ModelDescription desc, int index, int size) {
        for (ModelEventListener listener : this.listeners) {
            listener.loaded(clazz, desc, index, size);
        }
    }

    private void fireModelEnhancing(ModelDescription desc) {
        for (ModelEventListener listener : this.listeners) {
            byte[] bytes = listener.enhancing(desc);
            if (bytes != null) {
                desc.classBytecode = bytes;
                continue;
            }
            throw new EnhancingException("Enhance class byte code is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClass() {
        PackageNamesScanner scanner = new PackageNamesScanner(this.packages, true);
        while (scanner.hasNext()) {
            if (!((String)scanner.next()).endsWith(".class")) continue;
            InputStream in = scanner.open();
            try {
                ModelDescription desc = this.enhanceModel(in);
                if (desc == null || this.modelClassesDescList.contains(desc)) continue;
                this.modelClassesDescList.add(desc);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public String[] getPackages() {
        return Arrays.copyOf(this.packages, this.packages.length);
    }

    public List<ModelDescription> getModelClassesDesc() {
        return Lists.newArrayList(this.modelClassesDescList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelDescription enhanceModel(InputStream in) {
        ModelDescription modelDescription;
        classpool.importPackage(BASE_MODEL_PKG);
        CtClass clazz = classpool.makeClass(in);
        if (clazz.isInterface()) {
            return null;
        }
        if (clazz.getName().endsWith(".package")) {
            return null;
        }
        ModelDescription cache = descCache.get(clazz.getURL().toExternalForm());
        if (cache != null) {
            return cache;
        }
        logger.debug("\u589e\u5f3a\u6a21\u578b\u7c7b[{}]", (Object)clazz.getName());
        cache = new ModelDescription();
        cache.classFile = clazz.getURL().toExternalForm();
        cache.classSimpleName = clazz.getSimpleName();
        cache.className = clazz.getName();
        boolean idGetSetFixed = false;
        try {
            boolean hasDefaultConstructor = false;
            for (CtConstructor constructor : clazz.getDeclaredConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                hasDefaultConstructor = true;
                break;
            }
            if (!hasDefaultConstructor) {
                CtConstructor defaultConstructor = CtNewConstructor.defaultConstructor((CtClass)clazz);
                clazz.addConstructor(defaultConstructor);
            }
        }
        catch (Exception e) {
            logger.error("Error in ModelManager", (Throwable)e);
            throw new UnexpectedException("Error in PropertiesEnhancer", e);
        }
        for (CtField field : clazz.getDeclaredFields()) {
            if (!this.isProperty(field)) continue;
            String fieldName = StringUtils.capitalize((String)field.getName());
            String getterName = "get" + fieldName;
            CtMethod getter = null;
            CtClass fieldType = classpool.get(field.getType().getName());
            try {
                getter = clazz.getDeclaredMethod(getterName);
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            if (getter == null && (fieldType.getName().equals(Boolean.class.getName()) || fieldType.getName().equals(Boolean.TYPE.getName()))) {
                getterName = "is" + fieldName;
                try {
                    getter = clazz.getDeclaredMethod(getterName);
                }
                catch (NotFoundException e) {
                    // empty catch block
                }
            }
            if (getter == null) {
                this.createGetter(clazz, getterName, fieldType, field);
            }
            String setterName = "set" + fieldName;
            CtClass[] args = new CtClass[]{fieldType};
            if (!this.isFinal(field)) {
                try {
                    CtMethod ctMethod = clazz.getDeclaredMethod(setterName, args);
                    if (ctMethod.getParameterTypes().length != 1 || !ctMethod.getParameterTypes()[0].equals(field.getType()) || Modifier.isStatic((int)ctMethod.getModifiers())) {
                        throw new NotFoundException("it's not a setter !");
                    }
                }
                catch (NotFoundException e) {
                    this.createSetter(clazz, setterName, args, field);
                }
            }
            if (idGetSetFixed || field.getAnnotation(Id.class) == null) continue;
            try {
                clazz.getDeclaredMethod(ID_GETTER_NAME);
            }
            catch (NotFoundException e) {
                this.createIdGetter(clazz, getterName, fieldType);
            }
            try {
                clazz.getDeclaredMethod(ID_SETTER_NAME);
            }
            catch (NotFoundException e) {
                this.createIdSetter(clazz, setterName, args);
            }
            classpool.importPackage(fieldType.getPackageName());
            classpool.importPackage(clazz.getName());
            CtMethod _getFinder = new CtMethod(classpool.get(FINDER_C_NAME), GET_FINDER_M_NAME, new CtClass[]{classpool.get("java.lang.String")}, clazz);
            _getFinder.setModifiers(Modifier.setPublic((int)8));
            try {
                _getFinder.setBody("{Finder finder = getFinderCache(" + clazz.getSimpleName() + ".class);" + "if(finder == null)" + "try {" + "   finder = (Finder) getFinderConstructor().newInstance(new Object[]{$1," + fieldType.getSimpleName() + ".class," + clazz.getSimpleName() + ".class});" + "   putFinderCache(" + clazz.getSimpleName() + ".class , finder);" + "} catch (Exception e) {" + "    throw new ameba.exceptions.AmebaException(e);" + "}" + "if (finder == null) {\n" + "    throw new ameba.db.model.Model.NotFinderFindException();\n" + "}" + "return finder;}");
            }
            catch (CannotCompileException e) {
                throw new CannotCompileException("Entity Model must be extends ameba.db.model.Model", (Throwable)e);
            }
            clazz.addMethod(_getFinder);
            _getFinder = new CtMethod(classpool.get(FINDER_C_NAME), GET_FINDER_M_NAME, null, clazz);
            _getFinder.setModifiers(Modifier.setPublic((int)8));
            _getFinder.setBody("{return (Finder) withFinder(\"" + Model.DB_DEFAULT_SERVER_NAME + "\");}");
            clazz.addMethod(_getFinder);
            idGetSetFixed = true;
        }
        cache.classBytecode = clazz.toBytecode();
        this.fireModelEnhancing(cache);
        try {
            descCache.put(cache.classFile, cache);
            modelDescription = cache;
        }
        catch (Throwable throwable) {
            try {
                clazz.detach();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        clazz.detach();
        return modelDescription;
    }

    private CtMethod createSetter(CtClass clazz, String methodName, CtClass[] args, CtField field) throws CannotCompileException {
        CtMethod setter = new CtMethod(CtClass.voidType, methodName, args, clazz);
        setter.setModifiers(1);
        setter.setBody("{this." + field.getName() + "=$1;}");
        clazz.addMethod(setter);
        return setter;
    }

    private CtMethod createGetter(CtClass clazz, String methodName, CtClass fieldType, CtField field) throws CannotCompileException {
        CtMethod getter = new CtMethod(fieldType, methodName, null, clazz);
        getter.setModifiers(1);
        getter.setBody("{ return this." + field.getName() + "; }");
        clazz.addMethod(getter);
        return getter;
    }

    private CtMethod createIdSetter(CtClass clazz, String methodName, CtClass[] args) throws CannotCompileException {
        CtMethod setter = new CtMethod(CtClass.voidType, ID_SETTER_NAME, args, clazz);
        setter.setModifiers(1);
        setter.setBody("{this." + methodName + "($1);}");
        clazz.addMethod(setter);
        return setter;
    }

    private CtMethod createIdGetter(CtClass clazz, String methodName, CtClass fieldType) throws CannotCompileException {
        CtMethod getter = new CtMethod(fieldType, ID_GETTER_NAME, null, clazz);
        getter.setModifiers(1);
        getter.setBody("{ return this." + methodName + "(); }");
        clazz.addMethod(getter);
        return getter;
    }

    public static abstract class ModelEventListener {
        protected abstract byte[] enhancing(ModelDescription var1);

        protected abstract void loaded(Class var1, ModelDescription var2, int var3, int var4);
    }
}

