/*
 * Decompiled with CFR 0.152.
 */
package ameba.event;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.event.japi.LookupEventBus;
import ameba.event.AsyncListener;
import ameba.event.Event;
import com.google.common.collect.Maps;
import java.util.Map;

public abstract class AsyncEventBus<E extends Event, S extends ActorRef>
extends LookupEventBus<E, S, Class<? extends E>> {
    private AsyncEventBus() {
    }

    public static AsyncEventBus<Event, ActorRef> create(String actorSysName) {
        return new Sub(actorSysName);
    }

    public int compareSubscribers(S a, S b) {
        return 1;
    }

    public int mapSize() {
        return 0;
    }

    public Class<? extends E> classify(E event) {
        return event.getClass();
    }

    public void publish(E event, S subscriber) {
        subscriber.tell(event, ActorRef.noSender());
    }

    public abstract boolean subscribe(Class<? extends E> var1, AsyncListener var2);

    public abstract boolean unsubscribe(Class<? extends E> var1, AsyncListener var2);

    private static class Sub
    extends AsyncEventBus<Event, ActorRef> {
        private final ActorSystem actorSystem;
        private final Map<AsyncListener, ActorRef> actorRefMap = Maps.newHashMap();

        Sub(String actorSysName) {
            this.actorSystem = ActorSystem.create((String)actorSysName);
        }

        @Override
        public boolean subscribe(Class<? extends Event> eventClass, AsyncListener listener) {
            ActorRef actor = this.actorSystem.actorOf(Props.create(EventHandler.class, (Object[])new Object[]{listener}));
            boolean suc = this.subscribe(actor, eventClass);
            if (suc) {
                this.actorRefMap.put(listener, actor);
            }
            return suc;
        }

        @Override
        public boolean unsubscribe(Class<? extends Event> eventClass, AsyncListener listener) {
            ActorRef actor = this.actorRefMap.get(listener);
            if (actor != null) {
                boolean suc = this.unsubscribe(actor, eventClass);
                if (suc) {
                    this.actorRefMap.remove(listener);
                }
                return suc;
            }
            return false;
        }

        public static class EventHandler
        extends UntypedActor {
            AsyncListener listener;

            public EventHandler(AsyncListener listener) {
                this.listener = listener;
                listener.actor = this;
            }

            public void onReceive(Object message) {
                if (message instanceof Event) {
                    this.listener.onReceive((Event)message);
                } else {
                    this.unhandled(message);
                }
            }
        }
    }
}

