/*
 * Decompiled with CFR 0.152.
 */
package ameba.event;

import akka.actor.ActorRef;
import ameba.event.AsyncEventBus;
import ameba.event.AsyncListener;
import ameba.event.Event;
import ameba.event.Listener;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventBus {
    private final SetMultimap<Class<?>, Listener> listeners = HashMultimap.create();
    private final ReadWriteLock subscribersByTypeLock = new ReentrantReadWriteLock();
    private static final Logger logger = LoggerFactory.getLogger(EventBus.class);

    private EventBus() {
    }

    public static EventBus createMix(String busName) {
        return new Mixed(busName);
    }

    public static EventBus create() {
        return new EventBus(){};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Event> void subscribe(Class<E> event, Listener<E> listener) {
        this.subscribersByTypeLock.writeLock().lock();
        try {
            this.listeners.put(event, listener);
        }
        finally {
            this.subscribersByTypeLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Event> void unsubscribe(Class<E> event, Listener<E> listener) {
        this.subscribersByTypeLock.writeLock().lock();
        try {
            this.listeners.remove(event, listener);
        }
        finally {
            this.subscribersByTypeLock.writeLock().unlock();
        }
    }

    public void publish(Event event) {
        Set listenerSet = this.listeners.get(event.getClass());
        for (Listener listener : listenerSet) {
            try {
                listener.onReceive(event);
            }
            catch (Exception e) {
                logger.error(event.getClass().getName() + " event handler has a error", (Throwable)e);
            }
        }
    }

    public static class Mixed
    extends EventBus {
        private final AsyncEventBus<Event, ActorRef> asyncEventBus;

        Mixed(String busName) {
            this.asyncEventBus = AsyncEventBus.create(busName);
        }

        @Override
        public <E extends Event> void subscribe(Class<E> event, Listener<E> listener) {
            if (listener instanceof AsyncListener) {
                this.asyncEventBus.subscribe(event, (AsyncListener)listener);
            } else {
                super.subscribe(event, listener);
            }
        }

        @Override
        public <E extends Event> void unsubscribe(Class<E> event, Listener<E> listener) {
            if (listener instanceof AsyncListener) {
                this.asyncEventBus.unsubscribe(event, (AsyncListener)listener);
            } else {
                super.unsubscribe(event, listener);
            }
        }

        @Override
        public void publish(Event event) {
            if (event == null) {
                return;
            }
            this.asyncEventBus.publish(event);
            super.publish(event);
        }
    }
}

