/*
 * Decompiled with CFR 0.152.
 */
package ameba.exceptions;

import ameba.Ameba;
import ameba.exceptions.SourceAttachment;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;

public class AmebaException
extends RuntimeException {
    public AmebaException() {
    }

    protected AmebaException(Throwable cause) {
        super(cause);
    }

    public AmebaException(String message) {
        super(message);
    }

    public AmebaException(String message, Throwable cause) {
        super(message, cause);
    }

    public static InterestingSomething getInterestingSomething(Throwable cause) {
        InterestingSomething something = null;
        for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
            if (stackTraceElement.getLineNumber() <= 0) continue;
            String path = stackTraceElement.getClassName().replaceAll("\\.", "/");
            path = path.substring(0, path.lastIndexOf("/"));
            File source = new File(Ameba.getApp().getPackageRoot(), path);
            if (!source.exists() || !source.isDirectory()) continue;
            String fN = stackTraceElement.getFileName();
            int index = fN.indexOf("$");
            fN = index < 0 ? fN.substring(0, fN.indexOf(".")) : fN.substring(0, index);
            source = new File(source, fN + ".java");
            if (something == null) {
                something = new InterestingSomething(stackTraceElement, source);
                something.setUsefulFiles(Lists.newArrayList());
                something.setUsefulStackTraceElement(Lists.newArrayList());
                continue;
            }
            if (!source.exists()) continue;
            something.getUsefulStackTraceElements().add(stackTraceElement);
            something.getUsefulFiles().add(source);
        }
        return something;
    }

    public boolean isSourceAvailable() {
        return this instanceof SourceAttachment;
    }

    public Integer getLineNumber() {
        return -1;
    }

    public File getSourceFile() {
        return null;
    }

    public static class InterestingSomething {
        StackTraceElement stackTraceElement;
        File sourceFile;
        List<StackTraceElement> usefulStackTraceElement;
        List<File> usefulFiles;

        public InterestingSomething(StackTraceElement stackTraceElement, File sourceFile) {
            this.stackTraceElement = stackTraceElement;
            this.sourceFile = sourceFile;
        }

        public List<StackTraceElement> getUsefulStackTraceElements() {
            return this.usefulStackTraceElement;
        }

        void setUsefulStackTraceElement(List<StackTraceElement> usefulStackTraceElement) {
            this.usefulStackTraceElement = usefulStackTraceElement;
        }

        public List<File> getUsefulFiles() {
            return this.usefulFiles;
        }

        void setUsefulFiles(List<File> usefulFiles) {
            this.usefulFiles = usefulFiles;
        }

        public StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }

        public File getSourceFile() {
            return this.sourceFile;
        }
    }
}

