/*
 * Decompiled with CFR 0.152.
 */
package ameba.exceptions;

import ameba.Ameba;
import ameba.exceptions.AmebaExceptionWithJavaSource;
import ameba.util.IOUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ConfigErrorException
extends AmebaExceptionWithJavaSource {
    private String config;
    private String key;

    public ConfigErrorException(String message) {
        super(message);
    }

    public ConfigErrorException(String message, String key) {
        super(message);
        this.key = key;
    }

    public ConfigErrorException(String message, Throwable cause, Integer line) {
        super(message, cause, line);
    }

    public ConfigErrorException(String message, String key, Throwable cause) {
        super(message, cause, -1);
        this.key = key;
    }

    @Override
    public File getSourceFile() {
        return new File(Ameba.getApp().getConfigFile());
    }

    String getConfig() {
        if (this.config == null) {
            try {
                this.config = IOUtils.readFromResource((String)this.getSourceFile().getPath());
            }
            catch (IOException e) {
                this.config = null;
            }
        }
        return this.config;
    }

    @Override
    public List<String> getSource() {
        return this.getConfig() == null ? null : Lists.newArrayList((Object[])this.config.split("\\s"));
    }

    @Override
    public Integer getLineNumber() {
        if (this.line == null || this.line == -1) {
            int i = 0;
            List<String> lines = this.getSource();
            if (lines == null) {
                return null;
            }
            for (String line : lines) {
                ++i;
                if (!this.key.equals(line.split("=")[0])) continue;
                return i;
            }
        }
        return super.getLineNumber();
    }
}

