/*
 * Decompiled with CFR 0.152.
 */
package ameba.feature;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.fasterxml.jackson.jaxrs.xml.JacksonJaxbXMLProvider;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.internal.util.PropertiesHelper;

public class JacksonFeature
implements Feature {
    private static final String JSON_FEATURE = JacksonFeature.class.getSimpleName();

    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        context.property(PropertiesHelper.getPropertyNameForRuntime((String)"jersey.config.jsonFeature", (RuntimeType)config.getRuntimeType()), (Object)JSON_FEATURE);
        context.register(JsonParseExceptionMapper.class);
        context.register(JsonMappingException.class);
        context.register(JacksonJsonProvider.class, new Class[]{MessageBodyReader.class, MessageBodyWriter.class});
        context.register(JacksonXMLProvider.class, new Class[]{MessageBodyReader.class, MessageBodyWriter.class});
        return true;
    }

    public static void configureMapper(ObjectMapper mapper) {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public static class JacksonXMLProvider
    extends JacksonJaxbXMLProvider {
        protected static XmlMapper createDefaultMapper() {
            JacksonXmlModule module = new JacksonXmlModule();
            module.setDefaultUseWrapper(false);
            return new XmlMapper(module);
        }

        public JacksonXMLProvider() {
            this(JacksonXMLProvider.createDefaultMapper(), DEFAULT_ANNOTATIONS);
        }

        public JacksonXMLProvider(XmlMapper mapper, Annotations[] annotationsToUse) {
            super(mapper, annotationsToUse);
            JacksonFeature.configureMapper((ObjectMapper)mapper);
        }
    }

    public static class JacksonJsonProvider
    extends JacksonJaxbJsonProvider {
        public JacksonJsonProvider() {
            this(new ObjectMapper(), DEFAULT_ANNOTATIONS);
        }

        public JacksonJsonProvider(ObjectMapper objectMapper, Annotations[] annotationses) {
            super(objectMapper, annotationses);
            JacksonFeature.configureMapper(objectMapper);
        }
    }
}

