/*
 * Decompiled with CFR 0.152.
 */
package ameba.feature.ds;

import ameba.feature.ds.WebStatFilter;
import com.alibaba.druid.stat.DruidStatService;
import com.alibaba.druid.util.Utils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URI;
import java.util.HashMap;
import java.util.UUID;
import javax.inject.Singleton;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.NameBinding;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatViewFeature
implements Feature {
    public static final String PARAM_NAME_RESET_ENABLE = "ds.resetEnable";
    public static final String PARAM_NAME_USERNAME = "ds.loginUsername";
    public static final String PARAM_NAME_PASSWORD = "ds.loginPassword";
    public static final String SESSION_USER_KEY = "SVST";
    public static final String PARAM_NAME_JMX_URL = "ds.jmxUrl";
    public static final String PARAM_NAME_JMX_USERNAME = "ds.jmxUsername";
    public static final String PARAM_NAME_JMX_PASSWORD = "ds.jmxPassword";
    private static final Logger logger = LoggerFactory.getLogger(StatViewFeature.class);
    private static final String RESOURCE_PATH = "support/http/resources";
    private static String username = null;
    private static String password = "";
    private static String authorizeToken = null;
    private static String jmxUrl = null;
    private static String jmxUsername = null;
    private static String jmxPassword = null;
    private static MBeanServerConnection conn = null;
    private static DruidStatService statService = DruidStatService.getInstance();
    private static String dsPath = "/__ds";

    private static void init(Configuration configuration) {
        String param;
        StatViewFeature.initAuthEnv(configuration);
        try {
            param = (String)configuration.getProperty(PARAM_NAME_RESET_ENABLE);
            if (param != null && param.trim().length() != 0) {
                param = param.trim();
                boolean resetEnable = Boolean.parseBoolean(param);
                statService.setResetEnable(resetEnable);
            }
        }
        catch (Exception e) {
            String msg = "initParameter config error, resetEnable : " + configuration.getProperty(PARAM_NAME_RESET_ENABLE);
            logger.error(msg, (Throwable)e);
        }
        param = StatViewFeature.readInitParam(configuration, PARAM_NAME_JMX_URL);
        if (param != null) {
            jmxUrl = param;
            jmxUsername = StatViewFeature.readInitParam(configuration, PARAM_NAME_JMX_USERNAME);
            jmxPassword = StatViewFeature.readInitParam(configuration, PARAM_NAME_JMX_PASSWORD);
            try {
                StatViewFeature.initJmxConn();
            }
            catch (IOException e) {
                logger.error("init jmx connection error", (Throwable)e);
            }
        }
    }

    private static void initJmxConn() throws IOException {
        if (jmxUrl != null) {
            JMXServiceURL url = new JMXServiceURL(jmxUrl);
            HashMap env = null;
            if (jmxUsername != null) {
                env = Maps.newHashMap();
                String[] credentials = new String[]{jmxUsername, jmxPassword};
                env.put("jmx.remote.credentials", credentials);
            }
            JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
            conn = jmxc.getMBeanServerConnection();
        }
    }

    private static void initAuthEnv(Configuration configuration) {
        String paramPassword;
        String paramUserName = (String)configuration.getProperty(PARAM_NAME_USERNAME);
        if (StringUtils.isNotBlank((CharSequence)paramUserName)) {
            username = paramUserName;
        }
        if (StringUtils.isNotBlank((CharSequence)(paramPassword = (String)configuration.getProperty(PARAM_NAME_PASSWORD)))) {
            password = paramPassword;
        }
    }

    private static String readInitParam(Configuration configuration, String key) {
        String value = null;
        try {
            String param = (String)configuration.getProperty(key);
            if (param != null && (param = param.trim()).length() > 0) {
                value = param;
            }
        }
        catch (Exception e) {
            String msg = "initParameter config [" + key + "] error";
            logger.warn(msg, (Throwable)e);
        }
        return value;
    }

    private static String getJmxResult(MBeanServerConnection connetion, String url) throws Exception {
        ObjectName name = new ObjectName("com.alibaba.druid:type=DruidStatService");
        return (String)conn.invoke(name, "service", new String[]{url}, new String[]{String.class.getName()});
    }

    private static String genServiceResponse(String url) {
        String resp = null;
        if (jmxUrl == null) {
            resp = statService.service(url);
        } else if (conn == null) {
            try {
                StatViewFeature.initJmxConn();
            }
            catch (IOException e) {
                logger.error("init jmx connection error", (Throwable)e);
                resp = DruidStatService.returnJSONResult((int)-1, (Object)("init jmx connection error" + e.getMessage()));
            }
            if (conn != null) {
                try {
                    resp = StatViewFeature.getJmxResult(conn, url);
                }
                catch (Exception e) {
                    logger.error("get jmx data error", (Throwable)e);
                    resp = DruidStatService.returnJSONResult((int)-1, (Object)("get data error:" + e.getMessage()));
                }
            }
        } else {
            try {
                resp = StatViewFeature.getJmxResult(conn, url);
            }
            catch (Exception e) {
                logger.error("get jmx data error", (Throwable)e);
                resp = DruidStatService.returnJSONResult((int)-1, (Object)("get data error" + e.getMessage()));
            }
        }
        return resp;
    }

    public boolean configure(FeatureContext context) {
        Configuration configuration = context.getConfiguration();
        StatViewFeature.init(configuration);
        String path = (String)configuration.getProperty("ds.resource.path");
        if (StringUtils.isNotBlank((CharSequence)path)) {
            dsPath = path.startsWith("/") ? path : "/" + path;
        }
        context.register(WebStatFilter.class);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            authorizeToken = UUID.randomUUID().toString().toUpperCase();
            context.register(AuthorizationRequestFilter.class);
        }
        context.register((Object)new ModelProcessor(){

            public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
                ResourceModel.Builder resourceModelBuilder = new ResourceModel.Builder(resourceModel, false);
                Resource.Builder resourceBuilder = Resource.builder(DsStatViewResource.class);
                resourceBuilder.path(dsPath);
                Resource resource = resourceBuilder.build();
                resourceModelBuilder.addResource(resource);
                return resourceModelBuilder.build();
            }

            public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
                return subResourceModel;
            }
        });
        return true;
    }

    @Path(value="ds")
    @Singleton
    @DsAuthorization
    public static class DsStatViewResource {
        @POST
        @Path(value="submitLogin")
        @Consumes(value={"application/x-www-form-urlencoded"})
        public Response login(@FormParam(value="loginUsername") String uname, @FormParam(value="loginPassword") String pwd) {
            if (username.equals(uname) && password.equals(pwd)) {
                return Response.ok((Object)"success").cookie(new NewCookie[]{new NewCookie(StatViewFeature.SESSION_USER_KEY, authorizeToken)}).build();
            }
            return Response.ok((Object)"error").build();
        }

        @GET
        public Response index() throws IOException {
            return Response.temporaryRedirect((URI)URI.create(dsPath + "/index.html")).build();
        }

        @GET
        @Path(value="{path:.*}")
        public Response getService(@PathParam(value="path") String path) throws IOException {
            if ("".equals(path)) {
                return Response.temporaryRedirect((URI)URI.create(dsPath + "/index.html")).build();
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.indexOf(".json") >= 0) {
                return Response.ok((Object)StatViewFeature.genServiceResponse(path)).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            return this.returnResourceFile(path);
        }

        @POST
        @Path(value="{path:.*}")
        public Response postService(@PathParam(value="path") String path) throws IOException {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.indexOf(".json") >= 0) {
                return Response.ok((Object)StatViewFeature.genServiceResponse(path)).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            return this.returnResourceFile(path);
        }

        private Response returnResourceFile(String fileName) throws IOException {
            Response.ResponseBuilder builder = null;
            if (fileName.endsWith(".jpg")) {
                byte[] bytes = Utils.readByteArrayFromResource((String)(StatViewFeature.RESOURCE_PATH + fileName));
                builder = Response.ok((Object)bytes);
                return builder.build();
            }
            String text = Utils.readFromResource((String)(StatViewFeature.RESOURCE_PATH + fileName));
            builder = Response.ok((Object)text);
            if (fileName.endsWith(".css")) {
                builder.type("text/css;charset=utf-8");
            } else if (fileName.endsWith(".js")) {
                builder.type("text/javascript;charset=utf-8");
            }
            return builder.build();
        }
    }

    @DsAuthorization
    static class AuthorizationRequestFilter
    implements ContainerRequestFilter {
        AuthorizationRequestFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            String path = "/" + requestContext.getUriInfo().getPath();
            Cookie cookie = (Cookie)requestContext.getCookies().get(StatViewFeature.SESSION_USER_KEY);
            if (!(cookie != null && authorizeToken.equals(cookie.getValue()) || (dsPath + "/login.html").equals(path) || (dsPath + "/submitLogin").equals(path) || path.startsWith(dsPath + "/css") || path.startsWith(dsPath + "/js") || path.startsWith(dsPath + "/img"))) {
                requestContext.abortWith(Response.temporaryRedirect((URI)URI.create(dsPath + "/login.html")).build());
            }
        }
    }

    @NameBinding
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface DsAuthorization {
    }
}

