/*
 * Decompiled with CFR 0.152.
 */
package ameba.feature.ds;

import com.alibaba.druid.filter.stat.StatFilterContext;
import com.alibaba.druid.filter.stat.StatFilterContextListener;
import com.alibaba.druid.filter.stat.StatFilterContextListenerAdapter;
import com.alibaba.druid.support.http.stat.WebAppStat;
import com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.alibaba.druid.support.http.stat.WebRequestStat;
import com.alibaba.druid.support.http.stat.WebURIStat;
import com.alibaba.druid.support.profile.Profiler;
import com.alibaba.druid.util.PatternMatcher;
import com.alibaba.druid.util.ServletPathMatcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.ContainerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
class WebStatFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger logger = LoggerFactory.getLogger(WebStatFilter.class);
    public static final String PARAM_NAME_PORFILE_ENABLE = "ds.profileEnable";
    public static final String PARAM_NAME_SESSION_STAT_MAX_COUNT = "ds.sessionStatMaxCount";
    public static final String PARAM_NAME_EXCLUSIONS = "ds.exclusions";
    public static final String PARAM_NAME_PRINCIPAL_COOKIE_NAME = "ds.principalCookieName";
    public static final String PARAM_NAME_REAL_IP_HEADER = "ds.realIpHeader";
    public static final int DEFAULT_MAX_STAT_SESSION_COUNT = 100000;
    private static WebAppStat webAppStat = null;
    private static WebStatFilterContextListener statFilterContextListener = new WebStatFilterContextListener();
    protected static PatternMatcher pathMatcher = new ServletPathMatcher();
    private static Set<String> excludesPattern;
    private static int sessionStatMaxCount;
    private static boolean profileEnable;
    private static String contextPath;
    private static String principalCookieName;
    private static String realIpHeader;

    @Inject
    public WebStatFilter(Configuration configuration) {
        String param;
        if (webAppStat != null) {
            return;
        }
        String exclusions = (String)configuration.getProperty(PARAM_NAME_EXCLUSIONS);
        if (exclusions != null && exclusions.trim().length() != 0) {
            excludesPattern = new HashSet<String>(Arrays.asList(exclusions.split("\\s*,\\s*")));
        }
        if ((param = (String)configuration.getProperty(PARAM_NAME_PRINCIPAL_COOKIE_NAME)) != null && (param = param.trim()).length() != 0) {
            principalCookieName = param;
        }
        if ((param = (String)configuration.getProperty(PARAM_NAME_PORFILE_ENABLE)) != null && param.trim().length() != 0) {
            if ("true".equals(param = param.trim())) {
                profileEnable = true;
            } else if ("false".equals(param)) {
                profileEnable = false;
            } else {
                logger.error("WebStatFilter Parameter 'ds.profileEnable' config error");
            }
        }
        if ((param = (String)configuration.getProperty(PARAM_NAME_SESSION_STAT_MAX_COUNT)) != null && param.trim().length() != 0) {
            param = param.trim();
            try {
                sessionStatMaxCount = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                logger.error("WebStatFilter Parameter 'ds.sessionStatMaxCount' config error", (Throwable)e);
            }
        }
        if ((param = (String)configuration.getProperty(PARAM_NAME_REAL_IP_HEADER)) != null && (param = param.trim()).length() != 0) {
            realIpHeader = param;
        }
        StatFilterContext.getInstance().addContextListener((StatFilterContextListener)statFilterContextListener);
        contextPath = "/";
        if (webAppStat == null) {
            webAppStat = new WebAppStat(contextPath, sessionStatMaxCount);
        }
        WebAppStatManager.getInstance().addWebAppStatSet((Object)webAppStat);
    }

    private WebURIStat getUriStat(String requestURI) {
        int index;
        WebURIStat uriStat = webAppStat.getURIStat(requestURI, false);
        if (uriStat == null && (index = requestURI.indexOf(";jsessionid=")) != -1) {
            requestURI = requestURI.substring(0, index);
            uriStat = webAppStat.getURIStat(requestURI, false);
        }
        return uriStat;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String requestURI = this.getRequestURI(requestContext);
        if (this.isExclusion(requestURI)) {
            return;
        }
        long startNano = System.nanoTime();
        long startMillis = System.currentTimeMillis();
        WebRequestStat requestStat = new WebRequestStat(startNano, startMillis);
        WebRequestStat.set((WebRequestStat)requestStat);
        webAppStat.beforeInvoke();
        WebURIStat uriStat = this.getUriStat(requestURI);
        if (this.isProfileEnable()) {
            Profiler.initLocal();
            Profiler.enter((String)requestURI, (String)"WEB");
        }
        if (uriStat != null) {
            uriStat.beforeInvoke();
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String requestURI = this.getRequestURI(requestContext);
        if (this.isExclusion(requestURI) || WebRequestStat.current() == null) {
            return;
        }
        long endNano = System.nanoTime();
        WebRequestStat.current().setEndNano(endNano);
        long nanos = endNano - WebRequestStat.current().getStartNano();
        Throwable error = null;
        if (responseContext.getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode() && Throwable.class.isInstance(responseContext.getEntity())) {
            error = (Throwable)responseContext.getEntity();
        }
        webAppStat.afterInvoke(error, nanos);
        WebURIStat uriStat = this.getUriStat(requestURI);
        if (uriStat == null) {
            int status = responseContext.getStatus();
            if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                String errorUrl = contextPath + "error_" + status;
                uriStat = webAppStat.getURIStat(errorUrl, true);
            } else {
                uriStat = webAppStat.getURIStat(requestURI, true);
            }
            if (uriStat != null) {
                uriStat.beforeInvoke();
            }
        }
        if (uriStat != null) {
            uriStat.afterInvoke(error, nanos);
        }
        WebRequestStat.set(null);
        if (this.isProfileEnable()) {
            Profiler.release((long)nanos);
            Map requestStatsMap = Profiler.getStatsMap();
            if (uriStat != null) {
                uriStat.getProfiletat().record(requestStatsMap);
            }
            Profiler.removeLocal();
        }
    }

    protected String getRemoteAddress(ContainerRequestContext request) {
        String ip = null;
        if (realIpHeader != null && realIpHeader.length() != 0) {
            ip = request.getHeaderString(realIpHeader);
        }
        if (StringUtils.isBlank(ip)) {
            ip = request.getHeaderString("x-forwarded-for");
            if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeaderString("Proxy-Client-IP");
            }
            if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeaderString("WL-Proxy-Client-IP");
            }
            if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = "unknown";
            }
        }
        return ip;
    }

    public String getPrincipal(ContainerRequestContext httpRequest) {
        if (principalCookieName != null && httpRequest.getCookies().size() > 0) {
            Map cookies = httpRequest.getCookies();
            for (Cookie cookie : cookies.values()) {
                if (!principalCookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public boolean isExclusion(String requestURI) {
        if (excludesPattern == null) {
            return false;
        }
        if (contextPath != null && requestURI.startsWith(contextPath) && !(requestURI = requestURI.substring(contextPath.length())).startsWith("/")) {
            requestURI = "/" + requestURI;
        }
        for (String pattern : excludesPattern) {
            if (!pathMatcher.matches(pattern, requestURI)) continue;
            return true;
        }
        return false;
    }

    public String getRequestURI(ContainerRequestContext request) {
        return ((ContainerRequest)request).getPath(true);
    }

    public String getPrincipalCookieName() {
        return principalCookieName;
    }

    public boolean isProfileEnable() {
        return profileEnable;
    }

    public void setProfileEnable(boolean profileEnable) {
        WebStatFilter.profileEnable = profileEnable;
    }

    public void setWebAppStat(WebAppStat webAppStat) {
        WebStatFilter.webAppStat = webAppStat;
    }

    public WebAppStat getWebAppStat() {
        return webAppStat;
    }

    public String getContextPath() {
        return contextPath;
    }

    public int getSessionStatMaxCount() {
        return sessionStatMaxCount;
    }

    public WebStatFilterContextListener getStatFilterContextListener() {
        return statFilterContextListener;
    }

    static {
        sessionStatMaxCount = 100000;
        profileEnable = false;
    }

    static class WebStatFilterContextListener
    extends StatFilterContextListenerAdapter {
        WebStatFilterContextListener() {
        }

        public void addUpdateCount(int updateCount) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.addJdbcUpdateCount((long)updateCount);
            }
        }

        public void addFetchRowCount(int fetchRowCount) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.addJdbcFetchRowCount((long)fetchRowCount);
            }
        }

        public void executeBefore(String sql, boolean inTransaction) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcExecuteCount();
            }
        }

        public void executeAfter(String sql, long nanos, Throwable error) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.addJdbcExecuteTimeNano(nanos);
                if (error != null) {
                    reqStat.incrementJdbcExecuteErrorCount();
                }
            }
        }

        public void commit() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcCommitCount();
            }
        }

        public void rollback() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcRollbackCount();
            }
        }

        public void pool_connect() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcPoolConnectCount();
            }
        }

        public void pool_close(long nanos) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcPoolCloseCount();
            }
        }

        public void resultSet_open() {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcResultSetOpenCount();
            }
        }

        public void resultSet_close(long nanos) {
            WebRequestStat reqStat = WebRequestStat.current();
            if (reqStat != null) {
                reqStat.incrementJdbcResultSetCloseCount();
            }
        }
    }
}

