/*
 * Decompiled with CFR 0.152.
 */
package ameba.mvc;

import ameba.exceptions.ConfigErrorException;
import ameba.mvc.ErrorPageGenerator;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConstrainedTo(value=RuntimeType.SERVER)
public class ErrorPageFeature
implements Feature {
    private static final Logger logger = LoggerFactory.getLogger(ErrorPageFeature.class);
    private static final String GEN_CONF_KEY = "http.error.page.generator";

    public final boolean configure(FeatureContext featureContext) {
        HashMap errorMap = Maps.newHashMap();
        Map config = featureContext.getConfiguration().getProperties();
        String defaultTemplate = null;
        String clazz = (String)config.get(GEN_CONF_KEY);
        Class clz = null;
        if (StringUtils.isBlank((CharSequence)clazz)) {
            clz = ErrorPageGenerator.class;
        } else {
            try {
                clz = Class.forName(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigErrorException("http.error.page.generatorconfig error,not found class " + clazz, GEN_CONF_KEY, e);
            }
        }
        for (String key : config.keySet()) {
            int startIndex;
            String statusCodeStr;
            if (!StringUtils.isNotBlank((CharSequence)key) || !key.startsWith("http.error.page.") || !StringUtils.isNotBlank((CharSequence)(statusCodeStr = key.substring((startIndex = key.lastIndexOf(".")) + 1)))) continue;
            if (statusCodeStr.toLowerCase().equals("default")) {
                defaultTemplate = (String)config.get(key);
                defaultTemplate = defaultTemplate.startsWith("/") ? defaultTemplate : "/" + defaultTemplate;
                continue;
            }
            if (statusCodeStr.toLowerCase().equals("generator")) continue;
            try {
                String va = (String)config.get(key);
                int statusCode = Integer.parseInt(statusCodeStr);
                if (!StringUtils.isNotBlank((CharSequence)va)) continue;
                errorMap.put(statusCode, va.startsWith("/") ? va : "/" + va);
            }
            catch (Exception e) {
                logger.error("parse http.compression.minSize error", (Throwable)e);
            }
        }
        ErrorPageGenerator.setDefaultErrorTemplate(defaultTemplate);
        ErrorPageGenerator.pushAllErrorMap(errorMap);
        featureContext.register(clz);
        return true;
    }
}

