/*
 * Decompiled with CFR 0.152.
 */
package ameba.mvc;

import ameba.mvc.template.internal.Viewables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class ErrorPageGenerator
implements ExceptionMapper<Throwable> {
    protected static final HashMap<Integer, String> errorTemplateMap = Maps.newHashMap();
    public static final String DEFAULT_ERROR_PAGE_DIR = "/__views/ameba/error/";
    public static final String DEFAULT_404_ERROR_PAGE = "/__views/ameba/error/404.html";
    public static final String DEFAULT_5XX_PRODUCT_ERROR_PAGE = "/__views/ameba/error/500.html";
    public static final String DEFAULT_501_ERROR_PAGE = "/__views/ameba/error/501.html";
    public static final String DEFAULT_401_ERROR_PAGE = "/__views/ameba/error/403.html";
    public static final String DEFAULT_400_ERROR_PAGE = "/__views/ameba/error/400.html";
    public static final String DEFAULT_405_ERROR_PAGE = "/__views/ameba/error/405.html";
    private static final Logger logger = LoggerFactory.getLogger(ErrorPageGenerator.class);
    private static String defaultErrorTemplate;
    @Context
    protected javax.inject.Provider<ContainerRequestContext> requestProvider;

    static void pushErrorMap(int status, String tpl) {
        errorTemplateMap.put(status, tpl);
    }

    static void pushAllErrorMap(HashMap<Integer, String> map) {
        errorTemplateMap.putAll(map);
    }

    public static HashMap<Integer, String> getErrorTemplateMap() {
        return errorTemplateMap;
    }

    public static String getDefaultErrorTemplate() {
        return defaultErrorTemplate;
    }

    static void setDefaultErrorTemplate(String template) {
        defaultErrorTemplate = template;
    }

    public Response toResponse(Throwable exception) {
        String tplName;
        ContainerRequestContext request = (ContainerRequestContext)this.requestProvider.get();
        int status = 500;
        if (exception instanceof WebApplicationException) {
            status = ((WebApplicationException)exception).getResponse().getStatus();
        }
        if (StringUtils.isBlank((CharSequence)(tplName = errorTemplateMap.get(status)))) {
            if (StringUtils.isBlank((CharSequence)defaultErrorTemplate)) {
                if (status < 500) {
                    switch (status) {
                        case 401: 
                        case 403: {
                            tplName = DEFAULT_401_ERROR_PAGE;
                            break;
                        }
                        case 404: {
                            tplName = DEFAULT_404_ERROR_PAGE;
                            break;
                        }
                        case 405: {
                            tplName = DEFAULT_405_ERROR_PAGE;
                            break;
                        }
                        default: {
                            tplName = DEFAULT_400_ERROR_PAGE;
                            break;
                        }
                    }
                } else {
                    switch (status) {
                        case 501: {
                            tplName = DEFAULT_501_ERROR_PAGE;
                            break;
                        }
                        default: {
                            tplName = DEFAULT_5XX_PRODUCT_ERROR_PAGE;
                            break;
                        }
                    }
                }
            } else {
                tplName = defaultErrorTemplate;
            }
        }
        Viewable viewable = this.createViewable(tplName, request, status, exception);
        if (status == 500) {
            logger.error("\u670d\u52a1\u5668\u9519\u8bef", exception);
        }
        return Response.status((int)status).entity((Object)viewable).build();
    }

    private Viewable createViewable(String tplName, ContainerRequestContext request, int status, Throwable exception) {
        Error error = new Error(request, status, exception);
        return Viewables.newDefaultViewable(tplName, error);
    }

    public static class Error {
        private int status;
        private ContainerRequestContext request;
        private Throwable exception;

        public Error() {
        }

        public Error(ContainerRequestContext request, int status, Throwable exception) {
            this.status = status;
            this.exception = exception;
            this.request = request;
        }

        public int getStatus() {
            return this.status;
        }

        public ContainerRequestContext getRequest() {
            return this.request;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

