/*
 * Decompiled with CFR 0.152.
 */
package ameba.mvc.assets;

import ameba.mvc.assets.AssetsResource;
import ameba.util.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;

@ConstrainedTo(value=RuntimeType.SERVER)
public class AssetsFeature
implements Feature {
    private static final Map<String, String[]> assetsMap = Maps.newLinkedHashMap();

    public static Map<String, String[]> getAssetMap(Configuration configuration) {
        LinkedHashMap assetsMap = Maps.newLinkedHashMap();
        for (String key : configuration.getPropertyNames()) {
            if (!key.startsWith("resource.assets.") && !key.equals("resource.assets")) continue;
            String routePath = key.replaceFirst("^resource\\.assets", "");
            if (routePath.startsWith(".")) {
                routePath = routePath.substring(1);
            } else if (StringUtils.isBlank((CharSequence)routePath)) {
                routePath = "assets";
            }
            if (routePath.endsWith("/")) {
                routePath = routePath.substring(0, routePath.lastIndexOf("/"));
            }
            String value = (String)configuration.getProperty(key);
            String[] uris = value.split(",");
            ArrayList uriList = Lists.newArrayList();
            for (String uri : uris) {
                uriList.add(uri.startsWith("/") ? uri : "/" + uri);
            }
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            Object[] _uris = (String[])assetsMap.get(routePath);
            if (_uris == null) {
                assetsMap.put(routePath, uriList.toArray(uris));
                continue;
            }
            assetsMap.put(routePath, ArrayUtils.addAll((Object[])_uris, (Object[])uriList.toArray(uris)));
        }
        return assetsMap;
    }

    public static Map<String, String[]> getAssetsMap() {
        return Maps.newHashMap(assetsMap);
    }

    public static InputStream findAsset(String name, String file) {
        String[] dirs;
        InputStream in = null;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.lastIndexOf("/"));
        }
        if ((dirs = assetsMap.get(name)) != null) {
            for (String dir : dirs) {
                if (!dir.endsWith("/") && !file.startsWith("/")) {
                    dir = dir + "/";
                }
                if ((in = IOUtils.getResourceAsStream((String)(dir + file))) != null) break;
            }
        }
        return in;
    }

    public boolean configure(FeatureContext context) {
        Configuration configuration = context.getConfiguration();
        assetsMap.putAll(AssetsFeature.getAssetMap(configuration));
        context.register((Object)new ModelProcessor(){

            public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
                ResourceModel.Builder resourceModelBuilder = new ResourceModel.Builder(resourceModel, false);
                for (String routePath : assetsMap.keySet()) {
                    Resource.Builder resourceBuilder = Resource.builder(AssetsResource.class);
                    resourceBuilder.path(routePath);
                    Resource resource = resourceBuilder.build();
                    resourceModelBuilder.addResource(resource);
                }
                return resourceModelBuilder.build();
            }

            public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
                return subResourceModel;
            }
        });
        return true;
    }
}

