/*
 * Decompiled with CFR 0.152.
 */
package ameba.mvc.assets;

import ameba.mvc.assets.AssetsFeature;
import ameba.util.MimeType;
import java.io.InputStream;
import java.net.URI;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="assets")
@Singleton
public class AssetsResource {
    @GET
    @Path(value="{file:.*}")
    public Response getResource(@PathParam(value="file") String file, @Context UriInfo uriInfo) {
        InputStream in = AssetsFeature.findAsset(uriInfo.getPath().replace(file, ""), file);
        if (in == null) {
            return Response.status((int)404).build();
        }
        Response.ResponseBuilder builder = Response.ok((Object)in);
        String path = URI.create(file).getPath();
        int dot = path.lastIndexOf(46);
        if (dot > 0) {
            String ext = path.substring(dot + 1);
            String ct = MimeType.get((String)ext);
            if (ct != null) {
                builder.type(ct);
            }
        } else {
            builder.type(MimeType.get((String)"html"));
        }
        return builder.build();
    }
}

