/*
 * Decompiled with CFR 0.152.
 */
package ameba.mvc.route;

import ameba.mvc.route.RouteHelper;
import javax.inject.Singleton;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
public class RouteFeature
implements Feature {
    public boolean configure(FeatureContext context) {
        context.register((Object)new ModelProcessor(){

            public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
                ResourceModel.Builder resourceModelBuilder = new ResourceModel.Builder(resourceModel, false);
                String routePath = (String)configuration.getProperty("resource.helper.route.path");
                Resource.Builder resourceBuilder = Resource.builder(RouteHelper.class);
                if (StringUtils.isNotBlank((CharSequence)routePath)) {
                    resourceBuilder.path(routePath);
                }
                Resource resource = resourceBuilder.build();
                resourceModelBuilder.addResource(resource);
                return resourceModelBuilder.build();
            }

            public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
                return subResourceModel;
            }
        });
        context.register(RouteHelper.RouteRequestFilter.class);
        return true;
    }
}

