/*
 * Decompiled with CFR 0.152.
 */
package ameba.mvc.route;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.server.ExtendedResourceContext;
import org.glassfish.jersey.server.model.Resource;

@Singleton
@Path(value="route")
public class RouteHelper {
    private static final ThreadLocal<ContainerRequestContext> reqLocal = new ThreadLocal();
    @Context
    private ExtendedResourceContext resourceContext;

    public static ContainerRequestContext getCurrentRequestContext() {
        return reqLocal.get();
    }

    @GET
    public List<String> getRoutes() {
        List resourceList = this.resourceContext.getResourceModel().getResources();
        ArrayList routeList = Lists.newArrayList();
        for (Resource resource : resourceList) {
            String path;
            String string = path = resource.getPath().startsWith("/") ? "" : "/" + resource.getPath();
            if (resource.getAllMethods().size() > 0) {
                routeList.add(path);
            }
            for (Resource res : resource.getChildResources()) {
                routeList.add(path + (res.getPath().startsWith("/") ? "" : "/") + res.getPath());
            }
        }
        return routeList;
    }

    public static class RouteRequestFilter
    implements ContainerRequestFilter,
    ContainerResponseFilter {
        public void filter(ContainerRequestContext requestContext) throws IOException {
            reqLocal.set(requestContext);
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            reqLocal.remove();
        }
    }
}

