/*
 * Decompiled with CFR 0.152.
 */
package ameba.mvc.template.internal;

import ameba.Ameba;
import ameba.exceptions.AmebaExceptionWithJavaSource;
import ameba.mvc.ErrorPageGenerator;
import ameba.mvc.template.TemplateException;
import ameba.mvc.template.TemplateNotFoundException;
import ameba.util.IOUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Collections2;
import jersey.repackaged.com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;

@Provider
@Singleton
public abstract class AmebaTemplateProcessor<T>
extends AbstractTemplateProcessor<T> {
    public static final String PROTECTED_DIR = "_protected";
    public static final String INNER_TPL_DIR = "/__views/ameba/";
    Set<String> supportedExtensions;
    @Context
    private MessageBodyWorkers workers;
    @Inject
    private ServiceLocator serviceLocator;
    private MessageBodyWriter<Viewable> viewableMessageBodyWriter;
    private ErrorPageGenerator errorPageGenerator;
    private Charset charset;

    public AmebaTemplateProcessor(Configuration config, ServletContext servletContext, String propertySuffix, String ... supportedExtensions) {
        super(config, servletContext, propertySuffix, supportedExtensions);
        String charsetStr = (String)config.getProperty("app.charset");
        this.charset = Charset.forName(StringUtils.isBlank((CharSequence)charsetStr) ? "utf-8" : charsetStr);
        this.supportedExtensions = Sets.newHashSet((Iterable)Collections2.transform(Arrays.asList(supportedExtensions), (Function)new Function<String, String>(){

            public String apply(String input) {
                return (input = input.toLowerCase()).startsWith(".") ? input : "." + input;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBodyWriter<Viewable> getViewableMessageBodyWriter() {
        if (this.viewableMessageBodyWriter == null) {
            AmebaTemplateProcessor amebaTemplateProcessor = this;
            synchronized (amebaTemplateProcessor) {
                if (this.viewableMessageBodyWriter == null) {
                    this.viewableMessageBodyWriter = this.workers.getMessageBodyWriter(Viewable.class, Viewable.class, new Annotation[0], null);
                }
            }
        }
        return this.viewableMessageBodyWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ErrorPageGenerator getErrorPageGenerator() {
        if (this.errorPageGenerator == null) {
            AmebaTemplateProcessor amebaTemplateProcessor = this;
            synchronized (amebaTemplateProcessor) {
                if (this.errorPageGenerator == null) {
                    LinkedHashSet exceptionMappers = Sets.newLinkedHashSet();
                    exceptionMappers.addAll(Providers.getCustomProviders((ServiceLocator)this.serviceLocator, ExceptionMapper.class));
                    exceptionMappers.addAll(Providers.getProviders((ServiceLocator)this.serviceLocator, ExceptionMapper.class));
                    for (ExceptionMapper t : exceptionMappers) {
                        if (!(t instanceof ErrorPageGenerator)) continue;
                        this.errorPageGenerator = (ErrorPageGenerator)t;
                        return this.errorPageGenerator;
                    }
                }
            }
        }
        return this.errorPageGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T resolve(String name, MediaType mediaType) {
        Object t = super.resolve(name, mediaType);
        if (t == null && name != null && name.startsWith("/")) {
            for (String ex : this.supportedExtensions) {
                String file = name.endsWith(ex) ? name : name + ex;
                InputStream in = IOUtils.getResourceAsStream((String)file);
                try {
                    if (in != null) {
                        t = this.resolve(file.startsWith(INNER_TPL_DIR) ? null : file, new InputStreamReader(in, this.charset));
                        if (t == null) continue;
                        Object object = t;
                        return (T)object;
                        finally {
                            IOUtils.closeQuietly((InputStream)in);
                            continue;
                        }
                    }
                    if (this.resolve(file, (Reader)null) != null || !Ameba.getApp().getMode().isDev() || file.startsWith(INNER_TPL_DIR)) continue;
                    throw new TemplateNotFoundException("\u672a\u627e\u5230\u6a21\u677f:" + this.getBasePath() + file);
                }
                catch (TemplateNotFoundException e) {
                    throw e;
                }
                catch (TemplateException e) {
                    throw e;
                }
                catch (Exception e) {
                    TemplateException r = e instanceof ParseException ? this.createException((ParseException)e) : new TemplateException("Parse template error: " + this.getBasePath() + file, e, e.getStackTrace()[0].getLineNumber());
                    throw r;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
        return (T)t;
    }

    protected abstract TemplateException createException(ParseException var1);

    protected T resolve(String templatePath, Reader reader) throws Exception {
        try {
            if (templatePath == null) {
                T t = this.resolve(reader);
                return t;
            }
            T t = this.resolve(templatePath);
            return t;
        }
        catch (Exception e) {
            TemplateException r;
            if (e instanceof ParseException) {
                r = this.createException((ParseException)e);
            } else {
                if (e instanceof IllegalStateException) {
                    T t = null;
                    return t;
                }
                r = new TemplateException("Parse template error: " + templatePath, e, e.getStackTrace()[0].getLineNumber());
            }
            throw r;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    protected abstract T resolve(String var1) throws Exception;

    protected abstract T resolve(Reader var1) throws Exception;

    public void writeTo(T templateReference, Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException {
        try {
            this.writeTemplate(templateReference, viewable, mediaType, httpHeaders, out);
        }
        catch (Exception e) {
            AmebaExceptionWithJavaSource r;
            if (e instanceof ParseException) {
                r = this.createException((ParseException)e);
            } else {
                String file = this.getTemplateFile(templateReference);
                file = this.getBasePath() + file;
                File tFile = new File(file);
                String source = IOUtils.readFromResource((String)file);
                ArrayList sources = !"".equals(source) ? Lists.newArrayList((Object[])source.split("\n")) : Lists.newArrayList();
                r = e instanceof FileNotFoundException || e.getCause() instanceof FileNotFoundException ? new TemplateNotFoundException(e.getMessage(), e, -1, tFile, sources, -1) : new TemplateException("Write template error in  " + file + ". " + e.getMessage(), e, -1, tFile, sources, -1);
            }
            viewable = (Viewable)this.getErrorPageGenerator().toResponse(r).getEntity();
            this.getViewableMessageBodyWriter().writeTo((Object)viewable, Viewable.class, Viewable.class, new Annotation[0], mediaType, httpHeaders, out);
        }
    }

    public abstract String getTemplateFile(T var1);

    public abstract void writeTemplate(T var1, Viewable var2, MediaType var3, MultivaluedMap<String, Object> var4, OutputStream var5) throws Exception;
}

