/*
 * Decompiled with CFR 0.152.
 */
package ameba.mvc.template.internal;

import ameba.mvc.template.TemplateException;
import ameba.mvc.template.internal.AmebaTemplateProcessor;
import ameba.mvc.template.internal.HttlViewProcessor;
import ameba.mvc.template.internal.Viewables;
import java.io.OutputStream;
import java.io.Reader;
import java.text.ParseException;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;
import org.jvnet.hk2.annotations.Optional;

@Provider
public class NotFoundForward
implements ExtendedExceptionMapper<NotFoundException> {
    @Inject
    private javax.inject.Provider<UriInfo> uriInfo;
    private AbstractTemplateProcessor<Boolean> templateProcessor;
    private ThreadLocal<String> templatePath = new ThreadLocal();

    @Inject
    public NotFoundForward(Configuration config, @Optional ServletContext servletContext) {
        this.templateProcessor = new AmebaTemplateProcessor<Boolean>(config, servletContext, "httl", HttlViewProcessor.getExtends(config)){

            @Override
            protected TemplateException createException(ParseException e) {
                return null;
            }

            @Override
            protected Boolean resolve(String templatePath) throws Exception {
                return true;
            }

            @Override
            protected Boolean resolve(Reader reader) throws Exception {
                return true;
            }

            @Override
            public String getTemplateFile(Boolean templateReference) {
                return null;
            }

            @Override
            public void writeTemplate(Boolean templateReference, Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws Exception {
            }
        };
    }

    public Response toResponse(NotFoundException exception) {
        return Response.ok((Object)Viewables.newDefaultViewable(this.templatePath.get())).build();
    }

    private String getCurrentPath() {
        return "/" + ((UriInfo)this.uriInfo.get()).getPath();
    }

    public boolean isMappable(NotFoundException exception) {
        String path = this.getCurrentPath();
        if (path.startsWith("_protected")) {
            return false;
        }
        try {
            Boolean has = (Boolean)this.templateProcessor.resolve(path, (MediaType)null);
            if (has == null || !has.booleanValue()) {
                path = path + "/index";
                has = (Boolean)this.templateProcessor.resolve(path, (MediaType)null);
            }
            this.templatePath.set(path);
            return has != null && has != false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

