/*
 * Decompiled with CFR 0.152.
 */
package ameba.server;

import java.net.URI;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class Connector {
    protected URI httpServerBaseUri;
    protected String host;
    protected String name;
    protected boolean ajpEnabled;
    protected boolean secureEnabled;
    protected Integer port;
    protected String sslProtocol;
    protected boolean sslClientMode;
    protected boolean sslNeedClientAuth;
    protected boolean sslWantClientAuth;
    protected String sslKeyPassword;
    protected byte[] sslKeyStoreFile;
    protected String sslKeyStoreType;
    protected String sslKeyStorePassword;
    protected String sslKeyStoreProvider;
    protected String sslKeyManagerFactoryAlgorithm;
    protected String sslTrustPassword;
    protected byte[] sslTrustStoreFile;
    protected String sslTrustStorePassword;
    protected String sslTrustStoreType;
    protected String sslTrustStoreProvider;
    protected String sslTrustManagerFactoryAlgorithm;
    protected boolean sslConfigReady;
    protected Properties rawProperties;

    protected Connector() {
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public URI getHttpServerBaseUri() {
        return this.httpServerBaseUri;
    }

    public boolean isSecureEnabled() {
        return this.secureEnabled;
    }

    public boolean isSslClientMode() {
        return this.sslClientMode;
    }

    public boolean isSslNeedClientAuth() {
        return this.sslNeedClientAuth;
    }

    public boolean isSslWantClientAuth() {
        return this.sslWantClientAuth;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public byte[] getSslKeyStoreFile() {
        return this.sslKeyStoreFile;
    }

    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public String getSslTrustPassword() {
        return this.sslTrustPassword;
    }

    public byte[] getSslTrustStoreFile() {
        return this.sslTrustStoreFile;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public String getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    public boolean isSslConfigReady() {
        return this.sslConfigReady;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public String getSslKeyStoreProvider() {
        return this.sslKeyStoreProvider;
    }

    public String getSslTrustStoreProvider() {
        return this.sslTrustStoreProvider;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this.sslKeyManagerFactoryAlgorithm;
    }

    public String getSslTrustManagerFactoryAlgorithm() {
        return this.sslTrustManagerFactoryAlgorithm;
    }

    public boolean isAjpEnabled() {
        return this.ajpEnabled;
    }

    public String getName() {
        return this.name;
    }

    public Properties getRawProperties() {
        return this.rawProperties;
    }

    public static class Builder {
        Connector connector = new Connector();

        public static Builder create() {
            return new Builder();
        }

        public String getHost() {
            return this.connector.getHost();
        }

        public URI getHttpServerBaseUri() {
            return this.connector.getHttpServerBaseUri();
        }

        public boolean isSslWantClientAuth() {
            return this.connector.isSslWantClientAuth();
        }

        public String getSslTrustStoreProvider() {
            return this.connector.getSslTrustStoreProvider();
        }

        public String getSslKeyStoreProvider() {
            return this.connector.getSslKeyStoreProvider();
        }

        public String getSslTrustManagerFactoryAlgorithm() {
            return this.connector.getSslTrustManagerFactoryAlgorithm();
        }

        public String getSslProtocol() {
            return this.connector.getSslProtocol();
        }

        public boolean isAjpEnabled() {
            return this.connector.isAjpEnabled();
        }

        public Integer getPort() {
            return this.connector.getPort();
        }

        public boolean isSslClientMode() {
            return this.connector.isSslClientMode();
        }

        public byte[] getSslTrustStoreFile() {
            return this.connector.getSslTrustStoreFile();
        }

        public String getSslTrustStorePassword() {
            return this.connector.getSslTrustStorePassword();
        }

        public String getSslTrustPassword() {
            return this.connector.getSslTrustPassword();
        }

        public String getSslKeyStoreType() {
            return this.connector.getSslKeyStoreType();
        }

        public boolean isSslConfigReady() {
            return this.connector.isSslConfigReady();
        }

        public String getSslTrustStoreType() {
            return this.connector.getSslTrustStoreType();
        }

        public byte[] getSslKeyStoreFile() {
            return this.connector.getSslKeyStoreFile();
        }

        public String getSslKeyStorePassword() {
            return this.connector.getSslKeyStorePassword();
        }

        public String getSslKeyManagerFactoryAlgorithm() {
            return this.connector.getSslKeyManagerFactoryAlgorithm();
        }

        public boolean isSslNeedClientAuth() {
            return this.connector.isSslNeedClientAuth();
        }

        public boolean isSecureEnabled() {
            return this.connector.isSecureEnabled();
        }

        public String getSslKeyPassword() {
            return this.connector.getSslKeyPassword();
        }

        public Builder host(String host) {
            this.connector.host = host;
            return this;
        }

        public Builder ajpEnabled(boolean ajpEnabled) {
            this.connector.ajpEnabled = ajpEnabled;
            return this;
        }

        public Builder secureEnabled(boolean secureEnabled) {
            this.connector.secureEnabled = secureEnabled;
            return this;
        }

        public Builder port(Integer port) {
            this.connector.port = port;
            return this;
        }

        public Builder sslProtocol(String sslProtocol) {
            this.connector.sslProtocol = sslProtocol;
            return this;
        }

        public Builder sslClientMode(boolean sslClientMode) {
            this.connector.sslClientMode = sslClientMode;
            return this;
        }

        public Builder sslNeedClientAuth(boolean sslNeedClientAuth) {
            this.connector.sslNeedClientAuth = sslNeedClientAuth;
            return this;
        }

        public Builder sslWantClientAuth(boolean sslWantClientAuth) {
            this.connector.sslWantClientAuth = sslWantClientAuth;
            return this;
        }

        public Builder sslKeyPassword(String sslKeyPassword) {
            this.connector.sslKeyPassword = sslKeyPassword;
            return this;
        }

        public Builder sslKeyStoreFile(byte[] sslKeyStoreFile) {
            this.connector.sslKeyStoreFile = sslKeyStoreFile;
            return this;
        }

        public Builder sslKeyStoreType(String sslKeyStoreType) {
            this.connector.sslKeyStoreType = sslKeyStoreType;
            return this;
        }

        public Builder sslKeyStorePassword(String sslKeyStorePassword) {
            this.connector.sslKeyStorePassword = sslKeyStorePassword;
            return this;
        }

        public Builder sslKeyStoreProvider(String sslKeyStoreProvider) {
            this.connector.sslKeyStoreProvider = sslKeyStoreProvider;
            return this;
        }

        public Builder sslKeyManagerFactoryAlgorithm(String sslKeyManagerFactoryAlgorithm) {
            this.connector.sslKeyManagerFactoryAlgorithm = sslKeyManagerFactoryAlgorithm;
            return this;
        }

        public Builder sslTrustPassword(String sslTrustPassword) {
            this.connector.sslTrustPassword = sslTrustPassword;
            return this;
        }

        public void sslTrustStoreFile(byte[] sslTrustStoreFile) {
            this.connector.sslTrustStoreFile = sslTrustStoreFile;
        }

        public Builder sslTrustStorePassword(String sslTrustStorePassword) {
            this.connector.sslTrustStorePassword = sslTrustStorePassword;
            return this;
        }

        public Builder sslTrustStoreType(String sslTrustStoreType) {
            this.connector.sslTrustStoreType = sslTrustStoreType;
            return this;
        }

        public Builder sslTrustStoreProvider(String sslTrustStoreProvider) {
            this.connector.sslTrustStoreProvider = sslTrustStoreProvider;
            return this;
        }

        public Builder sslTrustManagerFactoryAlgorithm(String sslTrustManagerFactoryAlgorithm) {
            this.connector.sslTrustManagerFactoryAlgorithm = sslTrustManagerFactoryAlgorithm;
            return this;
        }

        public Builder name(String name) {
            this.connector.name = name;
            return this;
        }

        public Builder rawProperties(Properties properties) {
            this.connector.rawProperties = properties;
            return this;
        }

        public Connector build() {
            if (this.connector.httpServerBaseUri == null) {
                this.connector.httpServerBaseUri = URI.create("http" + (this.isSecureEnabled() ? "s" : "") + "://" + this.connector.getHost() + ":" + this.connector.port + "/");
            }
            if (this.connector.secureEnabled && this.connector.sslKeyStoreFile != null && StringUtils.isNotBlank((CharSequence)this.connector.sslKeyPassword) && StringUtils.isNotBlank((CharSequence)this.connector.sslKeyStorePassword)) {
                this.connector.sslConfigReady = true;
            }
            return this.connector;
        }
    }
}

