/*
 * Decompiled with CFR 0.152.
 */
package org.analogweb.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.analogweb.RequestContext;
import org.analogweb.ResponseContext;
import org.analogweb.core.DefaultResponseWriter;
import org.analogweb.core.FormatFailureException;
import org.analogweb.jackson.Bean;
import org.analogweb.jackson.JacksonJsonFormatter;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class JacksonJsonFormatterTest {
    private JacksonJsonFormatter formatter;
    private RequestContext context;
    private ResponseContext response;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.formatter = new JacksonJsonFormatter();
        this.context = (RequestContext)Mockito.mock(RequestContext.class);
        this.response = (ResponseContext)Mockito.mock(ResponseContext.class);
    }

    @Test
    public void testFormatAndWriteInto() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DefaultResponseWriter writer = new DefaultResponseWriter();
        Mockito.when((Object)this.response.getResponseWriter()).thenReturn((Object)writer);
        Date expectedDate = new SimpleDateFormat("yyyy/MM/dd").parse("1978/4/20");
        Bean source = new Bean("snowgoose", true, expectedDate);
        this.formatter.formatAndWriteInto(this.context, this.response, "UTF-8", (Object)source).writeInto((OutputStream)out);
        String actual = new String(out.toByteArray(), "UTF-8");
        Assert.assertThat((Object)actual, (Matcher)Is.is((Object)("{\"name\":\"snowgoose\",\"alive\":true,\"date\":" + expectedDate.getTime() + "}")));
    }

    @Test
    public void testFormatAndWriteIntoOccursIOException() throws Exception {
        this.thrown.expect(FormatFailureException.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DefaultResponseWriter writer = new DefaultResponseWriter();
        Mockito.when((Object)this.response.getResponseWriter()).thenReturn((Object)writer);
        ObjectMapper alwaysIOError = new ObjectMapper(){
            private static final long serialVersionUID = 1L;

            public void writeValue(OutputStream out, Object value) throws IOException, JsonGenerationException, JsonMappingException {
                throw new IOException();
            }
        };
        Bean source = new Bean("snowgoose", true, new SimpleDateFormat("yyyy/MM/dd").parse("1978/4/20"));
        this.formatter.setObjectMapper(alwaysIOError);
        this.formatter.formatAndWriteInto(this.context, this.response, "UTF-8", (Object)source).writeInto((OutputStream)out);
    }
}

