/*
 * Decompiled with CFR 0.152.
 */
package org.analogweb.jackson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.analogweb.Headers;
import org.analogweb.RequestContext;
import org.analogweb.core.ApplicationRuntimeException;
import org.analogweb.core.MediaTypes;
import org.analogweb.jackson.Bean;
import org.analogweb.jackson.JacksonJsonValueResolver;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class JacksonJsonValueResolverTest {
    private JacksonJsonValueResolver mapper;
    private RequestContext requestContext;
    private Headers headers;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.mapper = new JacksonJsonValueResolver();
        this.requestContext = (RequestContext)Mockito.mock(RequestContext.class);
        this.headers = (Headers)Mockito.mock(Headers.class);
        Mockito.when((Object)this.requestContext.getRequestHeaders()).thenReturn((Object)this.headers);
    }

    @Test
    public void testMapToType() throws Exception {
        Mockito.when((Object)this.headers.getValues("Content-Type")).thenReturn(Arrays.asList("application/json"));
        Date expectedDate = new SimpleDateFormat("yyyy/MM/dd").parse("1978/4/20");
        ByteArrayInputStream from = new ByteArrayInputStream(String.valueOf("{\"name\":\"snowgoose\",\"alive\":true,\"date\":" + expectedDate.getTime() + "}").getBytes());
        Mockito.when((Object)this.requestContext.getRequestBody()).thenReturn((Object)from);
        Bean actual = (Bean)this.mapper.resolveValue(this.requestContext, null, null, Bean.class, null);
        Assert.assertThat((Object)actual.getName(), (Matcher)Is.is((Object)"snowgoose"));
        Assert.assertThat((Object)actual.isAlive(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)actual.getDate(), (Matcher)Is.is((Object)expectedDate));
    }

    @Test
    public void testMapToTypeWithCharset() throws Exception {
        Mockito.when((Object)this.headers.getValues("Content-Type")).thenReturn(Arrays.asList("application/json ;charset=utf-8"));
        Date expectedDate = new SimpleDateFormat("yyyy/MM/dd").parse("1978/4/20");
        ByteArrayInputStream from = new ByteArrayInputStream(String.valueOf("{\"name\":\"snowgoose\",\"alive\":true,\"date\":" + expectedDate.getTime() + "}").getBytes());
        Mockito.when((Object)this.requestContext.getRequestBody()).thenReturn((Object)from);
        Bean actual = (Bean)this.mapper.resolveValue(this.requestContext, null, null, Bean.class, null);
        Assert.assertThat((Object)actual.getName(), (Matcher)Is.is((Object)"snowgoose"));
        Assert.assertThat((Object)actual.isAlive(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)actual.getDate(), (Matcher)Is.is((Object)expectedDate));
    }

    @Test
    public void testMapToTypeWithNullSource() throws Exception {
        this.thrown.expect(ApplicationRuntimeException.class);
        Mockito.when((Object)this.headers.getValues("Content-Type")).thenReturn(Arrays.asList("application/json"));
        Mockito.when((Object)this.requestContext.getRequestBody()).thenThrow(new Throwable[]{new IOException()});
        this.mapper.resolveValue(this.requestContext, null, null, Bean.class, null);
    }

    @Test
    public void testSupports() throws Exception {
        Assert.assertThat((Object)this.mapper.supports(MediaTypes.APPLICATION_JSON_TYPE), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.mapper.supports(MediaTypes.TEXT_PLAIN_TYPE), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.mapper.supports(MediaTypes.valueOf((String)"text/javascript")), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.mapper.supports(MediaTypes.valueOf((String)"aplication/javascript")), (Matcher)Is.is((Object)false));
    }
}

