/*
 * Decompiled with CFR 0.152.
 */
package org.analogweb.jackson;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.analogweb.annotation.Post;
import org.analogweb.annotation.RequestFormats;
import org.analogweb.annotation.Route;
import org.analogweb.core.fake.FakeApplication;
import org.analogweb.core.fake.ResponseResult;
import org.analogweb.jackson.Bean;
import org.analogweb.jackson.JsonType;
import org.analogweb.util.Maps;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@Route
public class JsonTypeTest {
    private FakeApplication app;

    @Before
    public void setUp() {
        this.app = FakeApplication.fakeApplication();
    }

    @After
    public void tearDown() {
        this.app.shutdown();
    }

    @Route
    @RequestFormats(value={"application/json"})
    @Post
    public String test(@JsonType Bean bean) {
        return bean.getName();
    }

    @Test
    public void testOk() {
        HashMap header = Maps.newHashMap((Object)"Content-Type", Arrays.asList("application/json"));
        ResponseResult result = this.app.request("jsontypetest/test", "POST", (Map)header, (InputStream)new ByteArrayInputStream("{\"name\":\"snowgooseyk\"}".getBytes()));
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)CoreMatchers.is((Object)200));
        MatcherAssert.assertThat((Object)result.getResponseBody().toString(), (Matcher)CoreMatchers.is((Object)"snowgooseyk"));
    }

    @Test
    public void testUnsupportedMediaType() {
        HashMap header = Maps.newHashMap((Object)"Content-Type", Arrays.asList("plain/text"));
        ResponseResult result = this.app.request("jsontypetest/test", "POST", (Map)header, (InputStream)new ByteArrayInputStream("{\"name\":\"snowgooseyk\"}".getBytes()));
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)CoreMatchers.is((Object)415));
    }
}

