/*
 * Decompiled with CFR 0.152.
 */
package org.analogweb.util.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import java.io.IOException;
import org.analogweb.util.logging.Log;
import org.analogweb.util.logging.Logs;
import org.analogweb.util.logging.Marker;
import org.analogweb.util.logging.Markers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class LogImplTest {
    private Log log;
    private StubAppender mockAppender;

    @Before
    public void setUp() throws Exception {
        this.resetLog(Level.ALL);
    }

    public void resetLog(Level level) {
        this.log = Logs.getLog(LogImplTest.class);
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        this.mockAppender = new StubAppender();
        root.addAppender((Appender)this.mockAppender);
        root.setLevel(level);
    }

    @Test
    public void testTraceLog() {
        Level level = Level.TRACE;
        String message = "analog log message.";
        IOException expectedException = new IOException();
        Markers.SimpleMarker marker = Markers.SimpleMarker.valueOf((String)"Marked");
        this.log.trace(message);
        this.verifyLog(level, message);
        this.log.trace(message, (Throwable)expectedException);
        this.verifyLog(level, message);
        this.log.trace((Marker)marker, message);
        this.verifyLog(level, (Marker)marker, message);
        message = "analog {} message.";
        this.log.trace((Marker)marker, message, new Object[]{"log"});
        this.verifyLog(level, (Marker)marker, "analog log message.");
        message = "analog log message.";
        this.log.trace((Marker)marker, message, (Throwable)expectedException);
        this.verifyLog(level, (Marker)marker, message);
        Assert.assertThat((Object)this.log.isTraceEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.log.isTraceEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)true));
        this.resetLog(Level.DEBUG);
        Assert.assertThat((Object)this.log.isTraceEnabled(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.log.isTraceEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testDebugLog() {
        Level level = Level.DEBUG;
        String message = "analog log message.";
        IOException expectedException = new IOException();
        Markers.SimpleMarker marker = Markers.SimpleMarker.valueOf((String)"Marked");
        this.log.debug(message);
        this.verifyLog(level, message);
        this.log.debug(message, (Throwable)expectedException);
        this.verifyLog(level, message);
        this.log.debug((Marker)marker, message);
        this.verifyLog(level, (Marker)marker, message);
        message = "analog {} message.";
        this.log.debug((Marker)marker, message, new Object[]{"log"});
        this.verifyLog(level, (Marker)marker, "analog log message.");
        message = "analog log message.";
        this.log.debug((Marker)marker, message, (Throwable)expectedException);
        this.verifyLog(level, (Marker)marker, message);
        Assert.assertThat((Object)this.log.isDebugEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.log.isDebugEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)true));
        this.resetLog(Level.INFO);
        Assert.assertThat((Object)this.log.isDebugEnabled(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.log.isDebugEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testInfoLog() {
        Level level = Level.INFO;
        String message = "analog log message.";
        IOException expectedException = new IOException();
        Markers.SimpleMarker marker = Markers.SimpleMarker.valueOf((String)"Marked");
        this.log.info(message);
        this.verifyLog(level, message);
        this.log.info(message, (Throwable)expectedException);
        this.verifyLog(level, message);
        this.log.info((Marker)marker, message);
        this.verifyLog(level, (Marker)marker, message);
        message = "analog {} message.";
        this.log.info((Marker)marker, message, new Object[]{"log"});
        this.verifyLog(level, (Marker)marker, "analog log message.");
        message = "analog log message.";
        this.log.info((Marker)marker, message, (Throwable)expectedException);
        this.verifyLog(level, (Marker)marker, message);
        Assert.assertThat((Object)this.log.isInfoEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.log.isInfoEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)true));
        this.resetLog(Level.WARN);
        Assert.assertThat((Object)this.log.isInfoEnabled(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.log.isInfoEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testWarnLog() {
        Level level = Level.WARN;
        String message = "analog log message.";
        IOException expectedException = new IOException();
        Markers.SimpleMarker marker = Markers.SimpleMarker.valueOf((String)"Marked");
        this.log.warn(message);
        this.verifyLog(level, message);
        this.log.warn(message, (Throwable)expectedException);
        this.verifyLog(level, message);
        this.log.warn((Marker)marker, message);
        this.verifyLog(level, (Marker)marker, message);
        message = "analog {} message.";
        this.log.warn((Marker)marker, message, new Object[]{"log"});
        this.verifyLog(level, (Marker)marker, "analog log message.");
        message = "analog log message.";
        this.log.warn((Marker)marker, message, (Throwable)expectedException);
        this.verifyLog(level, (Marker)marker, message);
        Assert.assertThat((Object)this.log.isWarnEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.log.isWarnEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)true));
        this.resetLog(Level.ERROR);
        Assert.assertThat((Object)this.log.isWarnEnabled(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.log.isWarnEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testErrorLog() {
        Level level = Level.ERROR;
        String message = "analog log message.";
        IOException expectedException = new IOException();
        Markers.SimpleMarker marker = Markers.SimpleMarker.valueOf((String)"Marked");
        this.log.error(message);
        this.verifyLog(level, message);
        this.log.error(message, (Throwable)expectedException);
        this.verifyLog(level, message);
        this.log.error((Marker)marker, message);
        this.verifyLog(level, (Marker)marker, message);
        message = "analog {} message.";
        this.log.error((Marker)marker, message, new Object[]{"log"});
        this.verifyLog(level, (Marker)marker, "analog log message.");
        message = "analog log message.";
        this.log.error((Marker)marker, message, (Throwable)expectedException);
        this.verifyLog(level, (Marker)marker, message);
        Assert.assertThat((Object)this.log.isErrorEnabled(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.log.isErrorEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)true));
        this.resetLog(Level.OFF);
        Assert.assertThat((Object)this.log.isErrorEnabled(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.log.isErrorEnabled((Marker)Markers.SimpleMarker.valueOf((String)"ROOT")), (Matcher)Is.is((Object)false));
        System.out.println(this.log.toString());
    }

    private void verifyLog(Level level, Marker marker, String message) {
        LoggingEvent event = this.mockAppender.latest();
        Assert.assertThat((Object)event.getLevel(), (Matcher)Is.is((Object)level));
        Assert.assertThat((Object)event.getMarker().getName(), (Matcher)Is.is((Object)marker.getName()));
        Assert.assertThat((Object)event.getFormattedMessage(), (Matcher)Is.is((Object)message));
    }

    private void verifyLog(Level level, String message) {
        LoggingEvent event = this.mockAppender.latest();
        Assert.assertThat((Object)event.getLevel(), (Matcher)Is.is((Object)level));
        Assert.assertThat((Object)event.getFormattedMessage(), (Matcher)Is.is((Object)message));
    }

    private static class StubAppender
    extends AppenderBase {
        private LoggingEvent event;

        private StubAppender() {
        }

        public synchronized void doAppend(Object eventObject) {
            this.event = (LoggingEvent)eventObject;
        }

        LoggingEvent latest() {
            return this.event;
        }

        protected void append(Object eventObject) {
        }
    }
}

