/*
 * Decompiled with CFR 0.152.
 */
package org.ancoron.postgresql.utils.test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class LoggingRunListener
extends RunListener {
    private static final Logger log = Logger.getLogger("test.logger");
    private static Set<String> classes = new HashSet<String>();
    private static Map<String, Long> startTimes = new HashMap<String, Long>();

    public void testFinished(Description d) throws Exception {
        double end = System.currentTimeMillis();
        double start = startTimes.get(d.getDisplayName()).doubleValue();
        log.log(Level.INFO, "Finished ({1} ms): {0}", new Object[]{d.getMethodName(), String.format("%.3f", (end - start) / 1000.0)});
    }

    public void testFailure(Failure f) throws Exception {
        log.log(Level.WARNING, "Failed: {0}", new Object[]{f.getDescription().getDisplayName()});
    }

    public void testStarted(Description d) throws Exception {
        if (!classes.contains(d.getClassName())) {
            classes.add(d.getClassName());
            log.log(Level.FINE, "Starting test class: {0}", d.getClassName());
        }
        log.log(Level.FINE, "Starting: {0}", d.getMethodName());
        startTimes.put(d.getDisplayName(), System.currentTimeMillis());
    }
}

