/*
 * Decompiled with CFR 0.152.
 */
package org.ancoron.postgresql.utils.test;

import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;

public class QuickTests {
    public static void main(String[] args) throws Exception {
        int j;
        ArrayList<byte[]> arrays = new ArrayList<byte[]>();
        arrays.add(new byte[]{0, 0, 0, 127});
        arrays.add(new byte[]{-1, 127, 127, 0});
        arrays.add(InetAddress.getByName("255.255.255.0").getAddress());
        arrays.add(InetAddress.getByName("fe80::20e:cff:fe33:d204").getAddress());
        arrays.add(InetAddress.getByName("fe80::10e:cff:fe33:d204").getAddress());
        arrays.add(InetAddress.getByName("fe80::e:cff:fe33:d204").getAddress());
        arrays.add(InetAddress.getByName("fe80::40e:cff:fe33:d204").getAddress());
        arrays.add(InetAddress.getByName("fe80::40e:cff:feff:ffff").getAddress());
        arrays.add(InetAddress.getByName("255.255.255.255").getAddress());
        arrays.add(InetAddress.getByName("0.0.0.0").getAddress());
        for (byte[] mask : arrays) {
            BigInteger bi = new BigInteger(1, mask);
            System.out.println("IP (" + QuickTests.toString(mask) + ") = " + bi.toString(10) + " (MAC = " + QuickTests.toString(QuickTests.getMac(mask)) + ")");
            System.out.println("this = " + QuickTests.toString(mask) + ", previous = " + QuickTests.toString(QuickTests.previous(mask)) + ", next = " + QuickTests.toString(QuickTests.next(mask)));
        }
        int netmask = 64;
        byte[] addr = InetAddress.getByName("fe80::20e:cff:fe33:d204").getAddress();
        byte[] low = new byte[addr.length];
        int i = netmask / 8;
        int s = 8 - netmask % 8;
        System.arraycopy(addr, 0, low, 0, i);
        if (s > 0 && s < 8) {
            byte b = addr[i];
            for (j = 0; j < s; ++j) {
                b = (byte)(b & ~(1 << j));
            }
            low[i] = b;
        }
        System.out.println("LOW(s=" + s + "): " + QuickTests.toString(low) + " (" + InetAddress.getByAddress(low).toString() + ")");
        byte[] hi = new byte[addr.length];
        i = netmask / 8;
        s = 8 - netmask % 8;
        System.arraycopy(addr, 0, hi, 0, i);
        if (s > 0 && s < 8) {
            byte b = addr[i];
            for (int j2 = 0; j2 < s; ++j2) {
                b = (byte)(b | 1 << j2);
            }
            hi[i] = b;
        }
        int n = j = s == 8 ? i : i + 1;
        while (j < hi.length) {
            hi[j] = -1;
            ++j;
        }
        System.out.println("HIGH(s=" + s + "): " + QuickTests.toString(hi) + " (" + InetAddress.getByAddress(hi).toString() + ")");
        netmask = 65;
        System.out.println("Netmask: " + QuickTests.toString(QuickTests.netmask(addr, netmask)));
        System.out.println("Hostmask: " + QuickTests.toString(QuickTests.hostmask(addr, netmask)));
        int n2 = (int)Math.pow(2.0, 30.0);
        int x = 1;
        while (1 << x < n2) {
            System.out.println("n = " + n2 + " <<< x = " + x + " (" + (1 << x) + ")");
            if (++x <= 30) continue;
        }
        System.out.println("n = " + n2 + " >>> x = " + x + " ((1<<" + x + ") = " + (1 << x) + ")");
    }

    private static byte[] previous(byte[] addr) {
        byte[] previous = new byte[addr.length];
        System.arraycopy(addr, 0, previous, 0, previous.length);
        int i = previous.length - 1;
        while (previous[i] == 0) {
            previous[i] = -1;
            if (--i != 0) continue;
            return null;
        }
        previous[i] = (byte)(previous[i] - 1 & 0xFF);
        return previous;
    }

    private static byte[] next(byte[] addr) {
        byte[] next = new byte[addr.length];
        System.arraycopy(addr, 0, next, 0, next.length);
        int i = next.length - 1;
        while (next[i] == -1) {
            if (--i != 0) continue;
            return null;
        }
        next[i] = (byte)(next[i] + 1 & 0xFF);
        return next;
    }

    private static byte[] netmask(byte[] addr, int netmask) {
        byte[] mask = new byte[addr.length];
        int i = netmask / 8;
        int s = 8 - netmask % 8;
        for (int j = 0; j < i; ++j) {
            mask[j] = -1;
        }
        if (s > 0 && s < 8) {
            int b = -1;
            for (int j = 0; j < s; ++j) {
                b = (byte)(b & ~(1 << j));
            }
            mask[i] = b;
        }
        return mask;
    }

    private static byte[] hostmask(byte[] addr, int netmask) {
        byte[] mask = new byte[addr.length];
        int i = netmask / 8;
        int s = 8 - netmask % 8;
        for (int j = i; j < mask.length; ++j) {
            mask[j] = -1;
        }
        if (s > 0 && s < 8) {
            byte b = 0;
            for (int j = 0; j < s; ++j) {
                b = (byte)(b | 1 << j);
            }
            mask[i] = b;
        }
        return mask;
    }

    private static byte[] getMac(byte[] fullIpv6) {
        if (fullIpv6.length != 16) {
            return null;
        }
        if (fullIpv6[11] != -1 || fullIpv6[12] != -2) {
            return null;
        }
        byte[] mac = new byte[]{(byte)(fullIpv6[8] ^ 2), fullIpv6[9], fullIpv6[10], fullIpv6[13], fullIpv6[14], fullIpv6[15]};
        return mac;
    }

    private static String toString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (byte b : bytes) {
            String bs;
            if (!first) {
                sb.append(",");
            }
            if ((bs = Integer.toHexString(0xFF & b)).length() == 1) {
                bs = "0" + bs;
            }
            sb.append(bs);
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }
}

