/*
 * Decompiled with CFR 0.152.
 */
package org.ancoron.postgresql.utils.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SingleLineLogFormatter
extends Formatter {
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private String lineSeparator = System.getProperty("line.separator");
    protected Date dat = new Date();
    protected boolean printClass = true;
    protected boolean printMethod = true;
    protected boolean printLevel = true;

    @Override
    public synchronized String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        this.dat.setTime(record.getMillis());
        sb.append("[").append(df.format(this.dat)).append("]");
        if (this.printClass || this.printMethod) {
            sb.append("[");
        }
        if (this.printClass) {
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            } else {
                sb.append(record.getLoggerName());
            }
        }
        if (this.printMethod && record.getSourceMethodName() != null) {
            if (this.printClass) {
                sb.append("::");
            }
            sb.append(record.getSourceMethodName());
        }
        if (this.printClass || this.printMethod) {
            sb.append("] ");
        }
        sb.append(String.format("%7s", record.getLevel().getLocalizedName()));
        String message = this.formatMessage(record);
        sb.append(": ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

