/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.ormlite.handler;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCatchBlock;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JTryBlock;
import com.helger.jcodemodel.JVar;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.handler.MethodInjectionHandler;
import org.androidannotations.helper.InjectHelper;
import org.androidannotations.helper.LogHelper;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.helper.ValidatorHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.ormlite.annotations.OrmLiteDao;
import org.androidannotations.ormlite.helper.OrmLiteHelper;
import org.androidannotations.ormlite.helper.OrmLiteValidatorHelper;
import org.androidannotations.ormlite.holder.OrmLiteHolder;

public class OrmLiteDaoHandler
extends BaseAnnotationHandler<EComponentHolder>
implements MethodInjectionHandler<EComponentHolder> {
    private final InjectHelper<EComponentHolder> injectHelper;
    private final OrmLiteHelper ormLiteHelper;
    private final OrmLiteValidatorHelper ormLiteValidatorHelper;

    public OrmLiteDaoHandler(AndroidAnnotationsEnvironment environment) {
        super(OrmLiteDao.class, environment);
        this.ormLiteHelper = new OrmLiteHelper((TargetAnnotationHelper)this.annotationHelper);
        this.ormLiteValidatorHelper = new OrmLiteValidatorHelper(environment);
        this.injectHelper = new InjectHelper((ValidatorHelper)this.validatorHelper, (MethodInjectionHandler)this);
    }

    public void validate(Element element, ElementValidation validation) {
        this.injectHelper.validate(OrmLiteDao.class, element, validation);
        if (!validation.isValid()) {
            return;
        }
        this.validatorHelper.isNotPrivate(element, validation);
        this.ormLiteValidatorHelper.hasOrmLiteJars(validation);
        Element param = this.injectHelper.getParam(element);
        this.ormLiteValidatorHelper.extendsOrmLiteDao(param, validation, this.ormLiteHelper);
        this.ormLiteValidatorHelper.hasASqliteOpenHelperParametrizedType(element, validation);
    }

    public void process(Element element, EComponentHolder holder) {
        this.injectHelper.process(element, (GeneratedClassHolder)holder);
    }

    public JBlock getInvocationBlock(EComponentHolder holder) {
        return holder.getInitBodyInjectionBlock();
    }

    public void assignValue(JBlock targetBlock, IJAssignmentTarget fieldRef, EComponentHolder holder, Element element, Element param) {
        OrmLiteHolder ormLiteHolder = (OrmLiteHolder)((Object)holder.getPluginHolder((Object)new OrmLiteHolder(holder)));
        AbstractJClass modelClass = this.getJClass(this.ormLiteHelper.getEntityType(param).toString());
        AbstractJClass idClass = this.getJClass(this.ormLiteHelper.getEntityIdType(param).toString());
        IJExpression modelClassDotClass = modelClass.dotclass();
        AbstractJClass daoClass = this.getJClass("com.j256.ormlite.dao.Dao").narrow(new AbstractJClass[]{modelClass, idClass});
        AbstractJClass daoImplClass = this.codeModelHelper.typeMirrorToJClass(param.asType());
        TypeMirror databaseHelperTypeMirror = (TypeMirror)this.annotationHelper.extractAnnotationParameter(element, "helper");
        JFieldVar databaseHelperRef = ormLiteHolder.getDatabaseHelperRef(databaseHelperTypeMirror);
        JInvocation injectExpr = databaseHelperRef.invoke("getDao").arg(modelClassDotClass);
        if (this.elementExtendsRuntimeExceptionDao(param)) {
            injectExpr = JExpr._new((AbstractJClass)daoImplClass).arg((IJExpression)JExpr.cast((AbstractJType)daoClass, (IJExpression)injectExpr));
        }
        JTryBlock tryBlock = targetBlock._try();
        tryBlock.body().add((IJStatement)fieldRef.assign((IJExpression)injectExpr));
        JCatchBlock catchBlock = tryBlock._catch(this.getClasses().SQL_EXCEPTION);
        JVar exception = catchBlock.param("e");
        String fieldName = param.getSimpleName().toString();
        catchBlock.body().staticInvoke(this.getClasses().LOG, "e").arg(LogHelper.logTagForClassHolder((GeneratedClassHolder)holder)).arg("Could not create DAO " + fieldName).arg((IJExpression)exception);
    }

    public void validateEnclosingElement(Element element, ElementValidation valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, valid);
    }

    private boolean elementExtendsRuntimeExceptionDao(Element element) {
        TypeMirror elementType = element.asType();
        return this.annotationHelper.isSubtype(elementType, (TypeMirror)this.ormLiteHelper.getRuntimeExceptionDaoParametrizedType());
    }
}

