/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.ormlite.helper;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.androidannotations.helper.TargetAnnotationHelper;

public class OrmLiteHelper {
    private final TargetAnnotationHelper helper;
    private DeclaredType daoParametrizedType;
    private DeclaredType runtimeExceptionDaoParametrizedType;
    private TypeElement daoTypeElement;
    private TypeElement runtimeExceptionDaoTypeElement;

    public OrmLiteHelper(TargetAnnotationHelper helper) {
        this.helper = helper;
    }

    public TypeMirror getEntityType(Element element) {
        return this.getEntityOrIdType(element, 0);
    }

    public TypeMirror getEntityIdType(Element element) {
        return this.getEntityOrIdType(element, 1);
    }

    private TypeMirror getEntityOrIdType(Element element, int index) {
        DeclaredType declaredType;
        List<? extends TypeMirror> typeArguments;
        if (this.isSubtypeOfDao(element.asType()) && (typeArguments = (declaredType = (DeclaredType)element.asType()).getTypeArguments()).size() == 2) {
            return typeArguments.get(index);
        }
        List superTypes = this.helper.directSupertypes(element.asType());
        for (TypeMirror superType : superTypes) {
            DeclaredType superDeclaredType;
            List<? extends TypeMirror> typeArguments2;
            if (superType.getKind() != TypeKind.DECLARED || !this.isSubtypeOfDao(superType) || (typeArguments2 = (superDeclaredType = (DeclaredType)superType).getTypeArguments()).size() != 2) continue;
            return typeArguments2.get(index);
        }
        return null;
    }

    private boolean isSubtypeOfDao(TypeMirror type) {
        return this.helper.isSubtype(type, (TypeMirror)this.daoParametrizedType) || this.helper.isSubtype(type, (TypeMirror)this.runtimeExceptionDaoParametrizedType);
    }

    public DeclaredType getDaoParametrizedType() {
        if (this.daoParametrizedType == null) {
            this.createDaoParametrizedTypes();
        }
        return this.daoParametrizedType;
    }

    public DeclaredType getRuntimeExceptionDaoParametrizedType() {
        if (this.runtimeExceptionDaoParametrizedType == null) {
            this.createDaoParametrizedTypes();
        }
        return this.runtimeExceptionDaoParametrizedType;
    }

    public DeclaredType getTypedDao(Element element) {
        if (this.daoTypeElement == null) {
            this.createDaoParametrizedTypes();
        }
        return this.helper.getTypeUtils().getDeclaredType(this.daoTypeElement, this.getEntityType(element), this.getEntityIdType(element));
    }

    public DeclaredType getTypedRuntimeExceptionDao(Element element) {
        if (this.runtimeExceptionDaoTypeElement == null) {
            this.createDaoParametrizedTypes();
        }
        return this.helper.getTypeUtils().getDeclaredType(this.runtimeExceptionDaoTypeElement, this.getEntityType(element), this.getEntityIdType(element));
    }

    private void createDaoParametrizedTypes() {
        this.daoTypeElement = this.helper.typeElementFromQualifiedName("com.j256.ormlite.dao.Dao");
        this.runtimeExceptionDaoTypeElement = this.helper.typeElementFromQualifiedName("com.j256.ormlite.dao.RuntimeExceptionDao");
        Types typeUtils = this.helper.getTypeUtils();
        WildcardType wildcardType = typeUtils.getWildcardType(null, null);
        this.daoParametrizedType = this.helper.getTypeUtils().getDeclaredType(this.daoTypeElement, wildcardType, wildcardType);
        this.runtimeExceptionDaoParametrizedType = this.helper.getTypeUtils().getDeclaredType(this.runtimeExceptionDaoTypeElement, wildcardType, wildcardType);
    }
}

