/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.ormlite.helper;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.androidannotations.AndroidAnnotationsEnvironment;
import org.androidannotations.ElementValidation;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.ormlite.annotations.OrmLiteDao;
import org.androidannotations.ormlite.helper.OrmLiteHelper;

public class OrmLiteValidatorHelper {
    public AnnotationHelper annotationHelper;

    public OrmLiteValidatorHelper(AndroidAnnotationsEnvironment environment) {
        this.annotationHelper = new AnnotationHelper(environment);
    }

    public void hasOrmLiteJars(ElementValidation valid) {
        Elements elementUtils = this.annotationHelper.getElementUtils();
        if (elementUtils.getTypeElement("com.j256.ormlite.dao.Dao") == null) {
            valid.addError("Could not find the OrmLite framework in the classpath, the following class is missing: com.j256.ormlite.dao.Dao");
        }
    }

    public void extendsOrmLiteDao(Element element, ElementValidation valid, OrmLiteHelper ormLiteHelper) {
        if (!valid.isValid()) {
            return;
        }
        TypeMirror elementTypeMirror = element.asType();
        Types typeUtils = this.annotationHelper.getTypeUtils();
        DeclaredType daoParametrizedType = ormLiteHelper.getDaoParametrizedType();
        DeclaredType runtimeExceptionDaoParametrizedType = ormLiteHelper.getRuntimeExceptionDaoParametrizedType();
        if (!this.annotationHelper.isSubtype(elementTypeMirror, (TypeMirror)daoParametrizedType) && !this.annotationHelper.isSubtype(elementTypeMirror, (TypeMirror)runtimeExceptionDaoParametrizedType)) {
            valid.addError("%s can only be used on an element that extends " + daoParametrizedType.toString() + " or " + runtimeExceptionDaoParametrizedType.toString());
            return;
        }
        if (this.annotationHelper.isSubtype(elementTypeMirror, (TypeMirror)runtimeExceptionDaoParametrizedType) && !typeUtils.isAssignable(ormLiteHelper.getTypedRuntimeExceptionDao(element), elementTypeMirror)) {
            boolean hasConstructor = false;
            Element elementType = typeUtils.asElement(elementTypeMirror);
            DeclaredType daoWithTypedParameters = ormLiteHelper.getTypedDao(element);
            for (ExecutableElement constructor : ElementFilter.constructorsIn(elementType.getEnclosedElements())) {
                TypeMirror type;
                List<? extends VariableElement> parameters = constructor.getParameters();
                if (parameters.size() != 1 || !this.annotationHelper.isSubtype(type = parameters.get(0).asType(), (TypeMirror)daoWithTypedParameters)) continue;
                hasConstructor = true;
            }
            if (!hasConstructor) {
                valid.addError(elementTypeMirror.toString() + " requires a constructor that takes only a " + daoWithTypedParameters.toString());
            }
        }
    }

    public void hasASqliteOpenHelperParametrizedType(Element element, ElementValidation valid) {
        TypeMirror openHelperType;
        TypeMirror helperType = (TypeMirror)this.annotationHelper.extractAnnotationParameter(element, OrmLiteDao.class.getName(), "helper");
        if (!this.annotationHelper.isSubtype(helperType, openHelperType = this.annotationHelper.typeElementFromQualifiedName("android.database.sqlite.SQLiteOpenHelper").asType())) {
            valid.addError("%s helper() parameter must extend android.database.sqlite.SQLiteOpenHelper");
        }
    }
}

